/*
 * Decompiled with CFR 0.152.
 */
package jodd.mail;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.URLName;
import jodd.mail.Email;
import jodd.mail.MailException;
import jodd.mail.SendMailSession;

public class EMLComposer {
    protected Session session;
    protected Properties properties;

    public static EMLComposer create() {
        return new EMLComposer();
    }

    public EMLComposer session(Session session) {
        this.session = session;
        return this;
    }

    public EMLComposer defaultSession() {
        this.session = Session.getDefaultInstance((Properties)System.getProperties());
        return this;
    }

    public EMLComposer set(Properties properties) {
        this.initProperties();
        this.properties.putAll((Map<?, ?>)properties);
        return this;
    }

    public EMLComposer set(String name, String value) {
        this.initProperties();
        this.properties.setProperty(name, value);
        return this;
    }

    public String compose(Email email) {
        if (this.session == null) {
            this.session = this.createSession(this.properties);
        }
        OutputStreamTransport ost = new OutputStreamTransport(this.session);
        SendMailSession sendMailSession = new SendMailSession(this.session, ost);
        sendMailSession.sendMail(email);
        return ost.getEml();
    }

    protected void initProperties() {
        if (this.session != null) {
            throw new MailException("Can't set properties after session is assigned");
        }
        if (this.properties == null) {
            this.properties = new Properties();
        }
    }

    protected Session createSession(Properties properties) {
        if (properties == null) {
            properties = System.getProperties();
        }
        return Session.getInstance((Properties)properties);
    }

    private static class OutputStreamTransport
    extends Transport {
        private String eml;

        public OutputStreamTransport(Session session) {
            super(session, new URLName("JODD_MAIL_2_EML", null, -1, null, null, null));
        }

        public void sendMessage(Message msg, Address[] addresses) throws MessagingException {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            try {
                msg.writeTo((OutputStream)outputStream);
            }
            catch (IOException e) {
                throw new MailException(e);
            }
            this.eml = outputStream.toString();
        }

        public String getEml() {
            return this.eml;
        }
    }
}

