/*
 * Decompiled with CFR 0.152.
 */
package org.liquibase.maven.plugins;

import liquibase.Liquibase;
import liquibase.database.Database;
import liquibase.exception.LiquibaseException;
import liquibase.resource.CompositeResourceAccessor;
import liquibase.resource.FileSystemResourceAccessor;
import liquibase.resource.ResourceAccessor;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.liquibase.maven.plugins.AbstractLiquibaseMojo;
import org.liquibase.maven.plugins.MavenResourceAccessor;

public abstract class AbstractLiquibaseChangeLogMojo
extends AbstractLiquibaseMojo {
    protected String changeLogFile;
    protected String contexts;
    protected String labels;

    @Override
    protected void checkRequiredParametersAreSpecified() throws MojoFailureException {
        super.checkRequiredParametersAreSpecified();
        if (this.changeLogFile == null) {
            throw new MojoFailureException("The changeLogFile must be specified.");
        }
    }

    @Override
    protected void performLiquibaseTask(Liquibase liquibase) throws LiquibaseException {
    }

    @Override
    protected void printSettings(String indent) {
        super.printSettings(indent);
        this.getLog().info((CharSequence)(indent + "changeLogFile: " + this.changeLogFile));
        this.getLog().info((CharSequence)(indent + "context(s): " + this.contexts));
        this.getLog().info((CharSequence)(indent + "label(s): " + this.labels));
    }

    @Override
    protected ResourceAccessor getFileOpener(ClassLoader cl) {
        MavenResourceAccessor mFO = new MavenResourceAccessor(cl);
        FileSystemResourceAccessor fsFO = new FileSystemResourceAccessor(this.project.getBasedir().getAbsolutePath());
        return new CompositeResourceAccessor(new ResourceAccessor[]{mFO, fsFO});
    }

    @Override
    protected Liquibase createLiquibase(ResourceAccessor fo, Database db) throws MojoExecutionException {
        try {
            String changeLog = this.changeLogFile == null ? "" : this.changeLogFile.trim();
            return new Liquibase(changeLog, fo, db);
        }
        catch (LiquibaseException ex) {
            throw new MojoExecutionException("Error creating liquibase: " + ex.getMessage(), (Exception)((Object)ex));
        }
    }
}

