/*
 * Decompiled with CFR 0.152.
 */
package org.moditect.mavenplugin.generate;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;
import org.moditect.mavenplugin.common.model.ArtifactConfiguration;
import org.moditect.mavenplugin.common.model.ModuleInfoConfiguration;
import org.moditect.mavenplugin.generate.ModuleInfoGenerator;
import org.moditect.mavenplugin.generate.model.ArtifactIdentifier;
import org.moditect.mavenplugin.generate.model.ModuleConfiguration;
import org.moditect.mavenplugin.util.ArtifactResolutionHelper;

@Mojo(name="generate-module-info", defaultPhase=LifecyclePhase.GENERATE_SOURCES, threadSafe=true)
public class GenerateModuleInfoMojo
extends AbstractMojo {
    @Component
    private ArtifactHandlerManager artifactHandlerManager;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;
    @Component
    private RepositorySystem repoSystem;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true, required=true)
    private RepositorySystemSession repoSession;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true, required=true)
    private List<RemoteRepository> remoteRepos;
    @Parameter(readonly=true, defaultValue="${project.build.directory}/moditect")
    private File workingDirectory;
    @Parameter(property="outputDirectory", defaultValue="${project.build.directory}/generated-sources/modules")
    private File outputDirectory;
    @Parameter
    private List<ModuleConfiguration> modules;
    @Parameter
    private List<String> jdepsExtraArgs;
    @Parameter(property="moditect.artifact")
    private String artifactOverride;
    @Parameter(property="moditect.additionalDependencies")
    private String additionalDependenciesOverride;
    @Parameter(property="moditect.moduleName")
    private String moduleNameOverride;
    @Parameter(property="moditect.exportExcludes")
    private String exportExcludesOverride;
    @Parameter(property="moditect.addServiceUses", defaultValue="false")
    private boolean addServiceUsesOverride;
    @Parameter(property="moditect.skip", defaultValue="false")
    private boolean skip;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().debug((CharSequence)"Mojo 'generate-module-info' skipped by configuration");
            return;
        }
        if (this.project.getModel().getPackaging().equalsIgnoreCase("pom")) {
            this.getLog().debug((CharSequence)("Mojo 'generate-module-info' not executed on packaging type '" + this.project.getModel().getPackaging() + "'"));
            return;
        }
        this.createDirectories();
        ArtifactResolutionHelper artifactResolutionHelper = new ArtifactResolutionHelper(this.repoSystem, this.repoSession, this.remoteRepos);
        ModuleInfoGenerator moduleInfoGenerator = new ModuleInfoGenerator(this.project, this.repoSystem, this.repoSession, this.remoteRepos, artifactResolutionHelper, this.jdepsExtraArgs, this.getLog(), this.workingDirectory, this.outputDirectory);
        Map<ArtifactIdentifier, String> assignedNamesByModule = this.getAssignedModuleNamesByModule(artifactResolutionHelper);
        if (this.artifactOverride != null) {
            ModuleConfiguration moduleConfiguration = this.getModuleConfigurationFromOverrides();
            moduleInfoGenerator.generateModuleInfo(moduleConfiguration.getArtifact(), moduleConfiguration.getAdditionalDependencies(), moduleConfiguration.getModuleInfo(), assignedNamesByModule, Collections.emptyMap());
        } else {
            for (ModuleConfiguration moduleConfiguration : this.modules) {
                moduleInfoGenerator.generateModuleInfo(moduleConfiguration.getArtifact(), moduleConfiguration.getAdditionalDependencies(), moduleConfiguration.getModuleInfo(), assignedNamesByModule, Collections.emptyMap());
            }
        }
    }

    private Map<ArtifactIdentifier, String> getAssignedModuleNamesByModule(ArtifactResolutionHelper artifactResolutionHelper) throws MojoExecutionException {
        HashMap<ArtifactIdentifier, String> assignedNamesByModule = new HashMap<ArtifactIdentifier, String>();
        for (ModuleConfiguration configuredModule : this.modules) {
            assignedNamesByModule.put(new ArtifactIdentifier(artifactResolutionHelper.resolveArtifact(configuredModule.getArtifact())), configuredModule.getModuleInfo().getName());
        }
        return assignedNamesByModule;
    }

    private ModuleConfiguration getModuleConfigurationFromOverrides() {
        ModuleConfiguration moduleConfiguration = new ModuleConfiguration();
        moduleConfiguration.setArtifact(new ArtifactConfiguration(this.artifactOverride));
        moduleConfiguration.setModuleInfo(new ModuleInfoConfiguration());
        moduleConfiguration.getModuleInfo().setName(this.moduleNameOverride);
        if (this.additionalDependenciesOverride != null) {
            for (String additionalDependency : this.additionalDependenciesOverride.split("\\,")) {
                moduleConfiguration.getAdditionalDependencies().add(new ArtifactConfiguration(additionalDependency));
            }
        }
        if (this.exportExcludesOverride != null) {
            moduleConfiguration.getModuleInfo().setExports(this.exportExcludesOverride);
        }
        moduleConfiguration.getModuleInfo().setAddServiceUses(this.addServiceUsesOverride);
        return moduleConfiguration;
    }

    private void createDirectories() {
        if (!this.workingDirectory.exists()) {
            this.workingDirectory.mkdirs();
        }
        if (!this.outputDirectory.exists()) {
            this.outputDirectory.mkdirs();
        }
    }
}

