/*
 * Decompiled with CFR 0.152.
 */
package org.moditect.mavenplugin.image;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.toolchain.Toolchain;
import org.apache.maven.toolchain.ToolchainManager;
import org.moditect.commands.CreateRuntimeImage;
import org.moditect.mavenplugin.image.model.Launcher;
import org.moditect.mavenplugin.util.DependencyHelper;
import org.moditect.mavenplugin.util.MojoLog;
import org.moditect.model.JarInclusionPolicy;
import org.moditect.spi.log.Log;

@Mojo(name="create-runtime-image", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, threadSafe=true)
public class CreateRuntimeImageMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;
    @Component
    private ToolchainManager toolchainManager;
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession mavenSession;
    @Parameter
    private String baseJdk;
    @Parameter(defaultValue="[]")
    private List<File> modulePath;
    @Parameter(property="outputDirectory", defaultValue="${project.build.directory}/image")
    private File outputDirectory;
    @Parameter(required=true)
    private List<String> modules;
    @Parameter
    private JarInclusionPolicy jarInclusionPolicy;
    @Parameter
    private Launcher launcher;
    @Parameter
    private String compression;
    @Parameter(defaultValue="false")
    private boolean stripDebug;
    @Parameter
    List<String> excludedResources;
    @Parameter(property="ignoreSigningInformation", defaultValue="false")
    private boolean ignoreSigningInformation;
    @Parameter(defaultValue="false")
    private boolean noHeaderFiles;
    @Parameter(defaultValue="false")
    private boolean noManPages;
    @Parameter(defaultValue="false")
    private boolean bindServices;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Path jmodsDir = this.getJModsDir();
        Set effectiveModulePath = this.modulePath.stream().map(File::toPath).collect(Collectors.toSet());
        effectiveModulePath.add(jmodsDir);
        Artifact primaryProjectArtifact = this.project.getArtifact();
        if (primaryProjectArtifact == null || !primaryProjectArtifact.getFile().exists()) {
            throw new MojoFailureException(CreateRuntimeImageMojo.getNoProjectArtifactMessage(primaryProjectArtifact));
        }
        CreateRuntimeImage createRuntimeImage = new CreateRuntimeImage(effectiveModulePath, this.modules, this.jarInclusionPolicy, DependencyHelper.getDirectAndTransitiveDependencies(this.project), primaryProjectArtifact.getFile().toPath(), this.launcher != null ? this.launcher.getName() : null, this.launcher != null ? this.launcher.getModule() : null, this.outputDirectory.toPath(), this.compression, this.stripDebug, this.ignoreSigningInformation, this.getExcludeResourcesPatterns(), (Log)new MojoLog(this.getLog()), this.noHeaderFiles, this.noManPages, this.bindServices);
        try {
            createRuntimeImage.run();
        }
        catch (IOException ex) {
            this.getLog().error((Throwable)ex);
            throw new MojoExecutionException("Error creating runtime image", (Exception)ex);
        }
    }

    private static String getNoProjectArtifactMessage(Artifact primaryProjectArtifact) {
        StringBuilder message = new StringBuilder();
        message.append("No primary project artifact was found to create a runtime image.");
        if (primaryProjectArtifact != null && primaryProjectArtifact.getFile() != null) {
            message.append(" The file ");
            message.append(primaryProjectArtifact.getFile());
            message.append(" does not exist.");
        }
        message.append(" Please make sure the project artifact has been created (usually in the package lifecycle phase).");
        message.append(" This goal should usually not run before artifact creation.");
        return message.toString();
    }

    private Path getJModsDir() throws MojoExecutionException {
        if (this.baseJdk != null) {
            List toolChains = this.toolchainManager.getToolchains(this.mavenSession, "jdk", this.getToolChainRequirements(this.baseJdk));
            if (toolChains.isEmpty()) {
                throw new MojoExecutionException("Found no tool chain of type 'jdk' and matching requirements '" + this.baseJdk + "'");
            }
            if (toolChains.size() > 1) {
                throw new MojoExecutionException("Found more than one tool chain of type 'jdk' and matching requirements '" + this.baseJdk + "'");
            }
            Toolchain toolchain = (Toolchain)toolChains.get(0);
            String javac = toolchain.findTool("javac");
            if (javac == null) {
                javac = toolchain.findTool("javac.exe");
            }
            if (javac == null) {
                throw new MojoExecutionException("Couldn't locate toolchain directory");
            }
            return new File(javac).toPath().getParent().getParent().resolve("jmods");
        }
        String javaHome = System.getProperty("java.home");
        return new File(javaHome).toPath().resolve("jmods");
    }

    private Map<String, String> getToolChainRequirements(String baseJdk) throws MojoExecutionException {
        String[] requirements;
        HashMap<String, String> toolChainRequirements = new HashMap<String, String>();
        for (String requirement : requirements = baseJdk.split(",")) {
            String[] keyAndValue = requirement.split("=");
            if (keyAndValue.length != 2) {
                throw new MojoExecutionException("Toolchain requirements must be given in the form 'key1=value1,key2=value2,...'.Given value '" + baseJdk + "' doesn't match this pattern.");
            }
            toolChainRequirements.put(keyAndValue[0].trim(), keyAndValue[1].trim());
        }
        return toolChainRequirements;
    }

    private List<String> getExcludeResourcesPatterns() {
        return this.excludedResources != null ? this.excludedResources : Collections.emptyList();
    }
}

