/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.annotation.core;

import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.molgenis.data.Entity;
import org.molgenis.data.annotation.core.RepositoryAnnotator;
import org.molgenis.data.annotation.core.entity.AnnotatorInfo;
import org.molgenis.data.meta.AttributeType;
import org.molgenis.data.meta.model.Attribute;
import org.molgenis.data.meta.model.EntityType;

public abstract class AbstractRepositoryAnnotator
implements RepositoryAnnotator {
    @Override
    public String canAnnotate(EntityType repoMetaData) {
        List<Attribute> annotatorAttributes = this.getRequiredAttributes();
        for (Attribute annotatorAttribute : annotatorAttributes) {
            if (repoMetaData.getAttribute(annotatorAttribute.getName()) == null) {
                return "missing required attribute";
            }
            if (!(repoMetaData.getAttribute(annotatorAttribute.getName()).getDataType() == annotatorAttribute.getDataType() || repoMetaData.getAttribute(annotatorAttribute.getName()).getDataType().equals((Object)AttributeType.STRING) && annotatorAttribute.getDataType().equals((Object)AttributeType.TEXT))) {
                return "a required attribute has the wrong datatype";
            }
            if (annotatorAttribute.getDataType().equals((Object)AttributeType.XREF)) {
                EntityType refEntity = repoMetaData.getAttribute(annotatorAttribute.getName()).getRefEntity();
                for (Attribute refAttribute : annotatorAttribute.getRefEntity().getAtomicAttributes()) {
                    if (refEntity.getAttribute(refAttribute.getName()) != null) continue;
                    return "the required referenced entity [" + StreamSupport.stream(annotatorAttribute.getRefEntity().getAtomicAttributes().spliterator(), false).map(Attribute::getName).collect(Collectors.joining(", ")) + "] is missing a required attribute";
                }
            }
            if (this.annotationDataExists()) continue;
            return "annotation datasource unreachable";
        }
        return "true";
    }

    @Override
    public Iterator<Entity> annotate(Iterator<Entity> sourceIterable) {
        return this.annotate(() -> sourceIterable);
    }

    @Override
    public String getFullName() {
        return "mgs_ann_" + this.getSimpleName();
    }

    @Override
    public String getDescription() {
        String desc = "TODO";
        AnnotatorInfo annotatorInfo = this.getInfo();
        if (annotatorInfo != null) {
            desc = annotatorInfo.getDescription();
        }
        return desc;
    }
}

