/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.annotation.core;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.molgenis.data.Entity;
import org.molgenis.data.annotation.core.AbstractRepositoryAnnotator;
import org.molgenis.data.annotation.core.exception.AnnotationException;
import org.molgenis.security.core.runas.RunAsSystem;
import org.springframework.transaction.annotation.Transactional;

public abstract class AbstractRepositoryEntityAnnotator
extends AbstractRepositoryAnnotator {
    @Override
    @RunAsSystem
    public Iterator<Entity> annotate(Iterable<Entity> sourceIterable) {
        return this.annotate(sourceIterable, false);
    }

    @Override
    @Transactional
    @RunAsSystem
    public Iterator<Entity> annotate(Iterable<Entity> sourceIterable, final boolean updateMode) {
        final Iterator<Entity> source = sourceIterable.iterator();
        return new Iterator<Entity>(){
            int current = 0;
            int size = 0;
            List<Entity> results;
            Entity result;

            @Override
            public boolean hasNext() {
                return this.current < this.size || source.hasNext();
            }

            @Override
            public Entity next() {
                Entity sourceEntity = null;
                if (this.current >= this.size) {
                    if (source.hasNext()) {
                        try {
                            sourceEntity = (Entity)source.next();
                            this.results = AbstractRepositoryEntityAnnotator.this.annotateEntity(sourceEntity, updateMode);
                        }
                        catch (Exception e) {
                            throw new AnnotationException(sourceEntity, this.current + 1, AbstractRepositoryEntityAnnotator.this.getRequiredAttributes(), AbstractRepositoryEntityAnnotator.this.getSimpleName(), e);
                        }
                        this.size = this.results.size();
                    }
                    this.current = 0;
                }
                this.result = !this.results.isEmpty() ? this.results.get(this.current) : sourceEntity;
                ++this.current;
                return this.result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public abstract List<Entity> annotateEntity(Entity var1, boolean var2) throws IOException, InterruptedException;
}

