/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.annotation.core;

import java.util.Iterator;
import java.util.List;
import org.molgenis.data.Entity;
import org.molgenis.data.MolgenisDataException;
import org.molgenis.data.annotation.core.entity.AnnotatorInfo;
import org.molgenis.data.annotation.core.resources.CmdLineAnnotatorSettingsConfigurer;
import org.molgenis.data.meta.model.Attribute;
import org.molgenis.data.meta.model.AttributeFactory;
import org.molgenis.data.meta.model.EntityType;

public interface RepositoryAnnotator {
    public static final String ANNOTATOR_PREFIX = "mgs_ann_";

    public AnnotatorInfo getInfo();

    default public Iterator<Entity> annotate(Iterable<Entity> source, boolean updateMode) {
        if (updateMode) {
            throw new MolgenisDataException("This annotator/filter does not support updating of values");
        }
        return this.annotate(source);
    }

    public Iterator<Entity> annotate(Iterable<Entity> var1);

    public boolean annotationDataExists();

    public Iterator<Entity> annotate(Iterator<Entity> var1);

    public List<Attribute> getOutputAttributes();

    public List<Attribute> getRequiredAttributes();

    public String canAnnotate(EntityType var1);

    public String getSimpleName();

    public String getFullName();

    public CmdLineAnnotatorSettingsConfigurer getCmdLineAnnotatorSettingsConfigurer();

    default public String getDescription() {
        return this.getInfo() == null ? "no description" : this.getInfo().getDescription();
    }

    public List<Attribute> createAnnotatorAttributes(AttributeFactory var1);
}

