/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.annotation.core.effects;

import java.util.LinkedList;
import org.molgenis.data.annotation.web.meta.AnnotatorEntityType;
import org.molgenis.data.meta.AttributeType;
import org.molgenis.data.meta.model.Attribute;
import org.molgenis.data.meta.model.AttributeFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EffectsMetaData
implements AnnotatorEntityType {
    @Autowired
    AttributeFactory attributeFactory;
    public static final String ID = "id";
    public static final String VARIANT = "VARIANT";
    public static final String ALT = "Alt_Allele";
    public static final String ANNOTATION = "Annotation";
    public static final String PUTATIVE_IMPACT = "Putative_impact";
    public static final String GENE_NAME = "Gene_Name";
    public static final String GENE_ID = "Gene_ID";
    public static final String FEATURE_TYPE = "Feature_type";
    public static final String FEATURE_ID = "Feature_ID";
    public static final String TRANSCRIPT_BIOTYPE = "Transcript_biotype";
    public static final String RANK_TOTAL = "Rank_total";
    public static final String HGVS_C = "HGVS_c";
    public static final String HGVS_P = "HGVS_p";
    public static final String C_DNA_POSITION = "cDNA_position";
    public static final String CDS_POSITION = "CDS_position";
    public static final String PROTEIN_POSITION = "Protein_position";
    public static final String DISTANCE_TO_FEATURE = "Distance_to_feature";
    public static final String ERRORS = "Errors";

    @Override
    public LinkedList<Attribute> getOrderedAttributes() {
        Attribute ALT_ATTR = this.getAltAttr();
        Attribute PUTATIVE_IMPACT_ATTR = this.getPutativeImpactAttr();
        Attribute GENE_NAME_ATTR = this.getGeneNameAttr();
        Attribute GENE_ID_ATTR = this.getGeneIdAttr();
        Attribute FEATURE_TYPE_ATTR = this.getFeatureTypeAttr();
        Attribute FEATURE_ID_ATTR = this.getFeatureIdAttr();
        Attribute TRANSCRIPT_BIOTYPE_ATTR = this.getTranscriptBiotypeAttr();
        Attribute RANK_TOTAL_ATTR = this.getRankTotalAttr();
        Attribute HGVS_C_ATTR = this.getHgvsCAttr();
        Attribute HGVS_P_ATTR = this.getHgvsPAttr();
        Attribute C_DNA_POSITION_ATTR = this.getCdnaPositionAttr();
        Attribute CDS_POSITION_ATTR = this.getCdsPositionAttr();
        Attribute PROTEIN_POSITION_ATTR = this.getProteinPositionAttr();
        Attribute DISTANCE_TO_FEATURE_ATTR = this.getDistanceToFeatureAttr();
        Attribute ERRORS_ATTR = this.getErrorsAttr();
        Attribute ANNOTATION_ATTR = this.getAnnotationAttr();
        LinkedList<Attribute> attributes = new LinkedList<Attribute>();
        attributes.add(ALT_ATTR);
        attributes.add(GENE_NAME_ATTR);
        attributes.add(ANNOTATION_ATTR);
        attributes.add(PUTATIVE_IMPACT_ATTR);
        attributes.add(GENE_ID_ATTR);
        attributes.add(FEATURE_TYPE_ATTR);
        attributes.add(FEATURE_ID_ATTR);
        attributes.add(TRANSCRIPT_BIOTYPE_ATTR);
        attributes.add(RANK_TOTAL_ATTR);
        attributes.add(HGVS_C_ATTR);
        attributes.add(HGVS_P_ATTR);
        attributes.add(C_DNA_POSITION_ATTR);
        attributes.add(CDS_POSITION_ATTR);
        attributes.add(PROTEIN_POSITION_ATTR);
        attributes.add(DISTANCE_TO_FEATURE_ATTR);
        attributes.add(ERRORS_ATTR);
        return attributes;
    }

    public Attribute getTranscriptBiotypeAttr() {
        return this.attributeFactory.create().setName(TRANSCRIPT_BIOTYPE).setDataType(AttributeType.STRING).setDescription("The bare minimum is at least a description on whether the transcript is {\u201cCoding\u201d, \u201cNoncoding\u201d}. Whenever possible, use ENSEMBL biotypes.(source:http://snpeff.sourceforge.net)").setAggregatable(true);
    }

    public Attribute getRankTotalAttr() {
        return this.attributeFactory.create().setName(RANK_TOTAL).setDataType(AttributeType.STRING).setDescription("Exon or Intron rank / total number of exons or introns(source:http://snpeff.sourceforge.net)");
    }

    public Attribute getHgvsCAttr() {
        return this.attributeFactory.create().setName(HGVS_C).setDataType(AttributeType.TEXT).setDescription("Variant using HGVS notation (DNA level)(source:http://snpeff.sourceforge.net)");
    }

    public Attribute getHgvsPAttr() {
        return this.attributeFactory.create().setName(HGVS_P).setDataType(AttributeType.STRING).setDescription("If variant is coding, this field describes the variant using HGVS notation (Protein level). Since transcript ID is already mentioned in \u2018feature ID\u2019, it may be omitted here.(source:http://snpeff.sourceforge.net)");
    }

    public Attribute getCdnaPositionAttr() {
        return this.attributeFactory.create().setName(C_DNA_POSITION).setDataType(AttributeType.STRING).setDescription("Position in cDNA and trancript\u2019s cDNA length (one based)(source:http://snpeff.sourceforge.net)");
    }

    public Attribute getCdsPositionAttr() {
        return this.attributeFactory.create().setName(CDS_POSITION).setDataType(AttributeType.STRING).setDescription("Position and number of coding bases (one based includes START and STOP codons)(source:http://snpeff.sourceforge.net)");
    }

    public Attribute getProteinPositionAttr() {
        return this.attributeFactory.create().setName(PROTEIN_POSITION).setDataType(AttributeType.STRING).setDescription("Position and number of AA (one based, including START, but not STOP)");
    }

    public Attribute getDistanceToFeatureAttr() {
        return this.attributeFactory.create().setName(DISTANCE_TO_FEATURE).setDataType(AttributeType.STRING).setDescription("All items in this field are options, so the field could be empty. Up/Downstream: Distance to first / last codon Intergenic: Distance to closest gene Distance to closest Intron boundary in exon (+/- up/downstream). If same, use positive number. Distance to closest exon boundary in Intron (+/- up/downstream) Distance to first base in MOTIF Distance to first base in miRNA Distance to exon-intron boundary in splice_site or splice _region ChipSeq peak: Distance to summit (or peak center) Histone mark / Histone state: Distance to summit (or peak center)(source:http://snpeff.sourceforge.net)");
    }

    public Attribute getErrorsAttr() {
        return this.attributeFactory.create().setName(ERRORS).setDataType(AttributeType.STRING).setDescription("Add errors, warnings oErrors, Warnings or Information messages: Add errors, warnings or r informative message that can affect annotation accuracy. It can be added using either \u2018codes\u2019 (as shown in column 1, e.g. W1) or \u2018message types\u2019 (as shown in column 2, e.g. WARNING_REF_DOES_NOT_MATCH_GENOME). All these errors, warnings or information messages messages are optional.(source:http://snpeff.sourceforge.net)");
    }

    public Attribute getAnnotationAttr() {
        return this.attributeFactory.create().setName(ANNOTATION).setDataType(AttributeType.STRING).setDescription("Annotated using Sequence Ontology terms. Multiple effects can be concatenated using \u2018&\u2019 (source:http://snpeff.sourceforge.net)").setAggregatable(true);
    }

    public Attribute getFeatureIdAttr() {
        return this.attributeFactory.create().setName(FEATURE_ID).setDataType(AttributeType.STRING).setDescription("Depending on the annotation, this may be: Transcript ID (preferably using version number), Motif ID, miRNA, ChipSeq peak, Histone mark, etc. Note: Some features may not have ID (e.g. histone marks from custom Chip-Seq experiments may not have a unique ID).(source:http://snpeff.sourceforge.net)");
    }

    public Attribute getFeatureTypeAttr() {
        return this.attributeFactory.create().setName(FEATURE_TYPE).setDataType(AttributeType.STRING).setDescription("Which type of feature is in the next field (e.g. transcript, motif, miRNA, etc.). It is preferred to use Sequence Ontology (SO) terms, but \u2018custom\u2019 (user defined) are allowed. ANN=A|stop_gained|HIGH|||transcript|... Tissue specific features may include cell type / tissue information separated by semicolon e.g.: ANN=A|histone_binding_site|LOW|||H3K4me3:HeLa-S3|...\nFeature ID: Depending on the annotation, this may be: Transcript ID (preferably using version number), Motif ID, miRNA, ChipSeq peak, Histone mark, etc. Note: Some features may not have ID (e.g. histone marks from custom Chip-Seq experiments may not have a unique ID). (source:http://snpeff.sourceforge.net)").setAggregatable(true);
    }

    public Attribute getGeneIdAttr() {
        return this.attributeFactory.create().setName(GENE_ID).setDataType(AttributeType.STRING).setDescription("Gene ID").setAggregatable(true);
    }

    public Attribute getGeneNameAttr() {
        return this.attributeFactory.create().setName(GENE_NAME).setDataType(AttributeType.STRING).setDescription("Common gene name (HGNC). Optional: use closest gene when the variant is \u201cintergenic\u201d(source:http://snpeff.sourceforge.net)").setAggregatable(true);
    }

    public Attribute getPutativeImpactAttr() {
        return this.attributeFactory.create().setName(PUTATIVE_IMPACT).setDataType(AttributeType.STRING).setDescription("A simple estimation of putative impact / deleteriousness : {HIGH, MODERATE, LOW, MODIFIER}(source:http://snpeff.sourceforge.net)").setAggregatable(true);
    }

    public Attribute getAltAttr() {
        return this.attributeFactory.create().setName(ALT).setDataType(AttributeType.TEXT).setDescription("The alternative allele on which this EFFECT applies");
    }
}

