/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.annotation.core.entity.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.molgenis.data.DataService;
import org.molgenis.data.Entity;
import org.molgenis.data.MolgenisDataException;
import org.molgenis.data.annotation.core.RepositoryAnnotator;
import org.molgenis.data.annotation.core.entity.AnnotatorConfig;
import org.molgenis.data.annotation.core.entity.AnnotatorInfo;
import org.molgenis.data.annotation.core.entity.QueryCreator;
import org.molgenis.data.annotation.core.entity.ResultFilter;
import org.molgenis.data.annotation.core.entity.impl.framework.AbstractAnnotator;
import org.molgenis.data.annotation.core.entity.impl.framework.RepositoryAnnotatorImpl;
import org.molgenis.data.annotation.core.filter.FirstResultFilter;
import org.molgenis.data.annotation.core.query.AttributeEqualsQueryCreator;
import org.molgenis.data.annotation.core.resources.Resource;
import org.molgenis.data.annotation.core.resources.Resources;
import org.molgenis.data.annotation.core.resources.impl.GeneCsvRepository;
import org.molgenis.data.annotation.core.resources.impl.RepositoryFactory;
import org.molgenis.data.annotation.core.resources.impl.ResourceImpl;
import org.molgenis.data.annotation.core.resources.impl.SingleResourceConfig;
import org.molgenis.data.annotation.web.settings.SingleFileLocationCmdLineAnnotatorSettingsConfigurer;
import org.molgenis.data.meta.AttributeType;
import org.molgenis.data.meta.model.Attribute;
import org.molgenis.data.meta.model.AttributeFactory;
import org.molgenis.data.meta.model.EntityTypeFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class CGDAnnotator
implements AnnotatorConfig {
    public static final String NAME = "CGD";
    private static String CGD_RESOURCE = "CGDResource";
    private static final char SEPARATOR = '\t';
    public static final String CONDITION_LABEL = "CGDCOND";
    public static final String AGE_GROUP_LABEL = "CGDAGE";
    public static final String INHERITANCE_LABEL = "CGDINH";
    public static final String GENERALIZED_INHERITANCE_LABEL = "CGDGIN";
    @Autowired
    private Entity CGDAnnotatorSettings;
    @Autowired
    private DataService dataService;
    @Autowired
    private Resources resources;
    @Autowired
    private EntityTypeFactory entityTypeFactory;
    @Autowired
    private AttributeFactory attributeFactory;
    private RepositoryAnnotatorImpl annotator;

    @Bean
    public RepositoryAnnotator cgd() {
        this.annotator = new RepositoryAnnotatorImpl(NAME);
        return this.annotator;
    }

    @Override
    public void init() {
        AnnotatorInfo info = this.getAnnotatorInfo();
        AttributeEqualsQueryCreator queryCreator = new AttributeEqualsQueryCreator(this.attributeFactory.create().setName(CGDAttributeName.GENE.getAttributeName()));
        FirstResultFilter resultFilter = new FirstResultFilter();
        CGDEntityAnnotator entityAnnotator = new CGDEntityAnnotator(CGD_RESOURCE, info, queryCreator, resultFilter, this.dataService, this.resources);
        this.annotator.init(entityAnnotator);
    }

    @Bean
    public Resource cgdResource() {
        return new ResourceImpl(CGD_RESOURCE, new SingleResourceConfig("cgdLocation", this.CGDAnnotatorSettings)){

            @Override
            public RepositoryFactory getRepositoryFactory() {
                return file -> new GeneCsvRepository(file, CGDAttributeName.GENE.getCgdName(), CGDAttributeName.GENE.getAttributeName(), CGDAnnotator.this.entityTypeFactory, CGDAnnotator.this.attributeFactory, '\t');
            }
        };
    }

    private AnnotatorInfo getAnnotatorInfo() {
        return AnnotatorInfo.create(AnnotatorInfo.Status.READY, AnnotatorInfo.Type.PHENOTYPE_ASSOCIATION, NAME, "Clinical Genomics Database", this.getOutputAttributes());
    }

    private List<Attribute> getOutputAttributes() {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        attributes.add(this.attributeFactory.create().setName(CGDAttributeName.HGNC_ID.getAttributeName()).setDataType(AttributeType.STRING));
        attributes.add(this.attributeFactory.create().setName(CGDAttributeName.ENTREZ_GENE_ID.getAttributeName()).setDataType(AttributeType.TEXT));
        attributes.add(this.attributeFactory.create().setName(CGDAttributeName.CONDITION.getAttributeName()).setDataType(AttributeType.TEXT).setLabel(CONDITION_LABEL));
        attributes.add(this.attributeFactory.create().setName(CGDAttributeName.INHERITANCE.getAttributeName()).setDataType(AttributeType.TEXT).setLabel(INHERITANCE_LABEL));
        attributes.add(this.attributeFactory.create().setName(CGDAttributeName.GENERALIZED_INHERITANCE.getAttributeName()).setDataType(AttributeType.TEXT).setLabel(GENERALIZED_INHERITANCE_LABEL));
        attributes.add(this.attributeFactory.create().setName(CGDAttributeName.AGE_GROUP.getAttributeName()).setDataType(AttributeType.TEXT).setLabel(AGE_GROUP_LABEL));
        attributes.add(this.attributeFactory.create().setName(CGDAttributeName.ALLELIC_CONDITIONS.getAttributeName()).setDataType(AttributeType.TEXT));
        attributes.add(this.attributeFactory.create().setName(CGDAttributeName.MANIFESTATION_CATEGORIES.getAttributeName()).setDataType(AttributeType.TEXT));
        attributes.add(this.attributeFactory.create().setName(CGDAttributeName.INTERVENTION_CATEGORIES.getAttributeName()).setDataType(AttributeType.TEXT));
        attributes.add(this.attributeFactory.create().setName(CGDAttributeName.COMMENTS.getAttributeName()).setDataType(AttributeType.TEXT));
        attributes.add(this.attributeFactory.create().setName(CGDAttributeName.INTERVENTION_RATIONALE.getAttributeName()).setDataType(AttributeType.TEXT));
        attributes.add(this.attributeFactory.create().setName(CGDAttributeName.REFERENCES.getAttributeName()).setDataType(AttributeType.TEXT));
        return attributes;
    }

    private class CGDEntityAnnotator
    extends AbstractAnnotator {
        public CGDEntityAnnotator(String sourceRepositoryName, AnnotatorInfo info, QueryCreator queryCreator, ResultFilter resultFilter, DataService dataService, Resources resources) {
            super(sourceRepositoryName, info, queryCreator, resultFilter, dataService, resources, new SingleFileLocationCmdLineAnnotatorSettingsConfigurer("cgdLocation", CGDAnnotator.this.CGDAnnotatorSettings));
        }

        @Override
        protected Object getResourceAttributeValue(Attribute attr, Entity sourceEntity) {
            if (attr.getName().equals(CGDAttributeName.GENERALIZED_INHERITANCE.getAttributeName())) {
                return this.getGeneralizedInheritance(sourceEntity);
            }
            String sourceName = CGDAttributeName.getCgdName(attr.getName());
            if (sourceName == null) {
                throw new MolgenisDataException("Unknown attribute [" + attr.getName() + "]");
            }
            return sourceEntity.get(sourceName);
        }

        private String getGeneralizedInheritance(Entity sourceEntity) {
            GeneralizedInheritance inherMode = GeneralizedInheritance.OTHER;
            String value = sourceEntity.getString(CGDAttributeName.INHERITANCE.getCgdName());
            if (value != null) {
                if (value.contains("AD") && value.contains("AR")) {
                    inherMode = GeneralizedInheritance.DOM_OR_REC;
                } else if (value.contains("AR")) {
                    inherMode = GeneralizedInheritance.RECESSIVE;
                } else if (value.contains("AD")) {
                    inherMode = GeneralizedInheritance.DOMINANT;
                } else if (value.contains("XL")) {
                    inherMode = GeneralizedInheritance.XLINKED;
                }
            }
            return inherMode.toString();
        }

        @Override
        public List<Attribute> createAnnotatorAttributes(AttributeFactory attributeFactory) {
            return CGDAnnotator.this.getOutputAttributes();
        }
    }

    public static enum CGDAttributeName {
        GENE("#GENE", "Gene_Name"),
        REFERENCES("REFERENCES", "REFS"),
        INTERVENTION_RATIONALE("INTERVENTION/RATIONALE", "INTERVENTION_RATIONALE"),
        COMMENTS("COMMENTS", "COMMENTS"),
        INTERVENTION_CATEGORIES("INTERVENTION CATEGORIES", "INTERVENTION_CATEGORIES"),
        MANIFESTATION_CATEGORIES("MANIFESTATION CATEGORIES", "MANIFESTATION_CATEGORIES"),
        ALLELIC_CONDITIONS("ALLELIC CONDITIONS", "ALLELIC_CONDITIONS"),
        ENTREZ_GENE_ID("ENTREZ GENE ID", "ENTREZ_GENE_ID"),
        HGNC_ID("HGNC ID", "HGNC_ID"),
        CONDITION("CONDITION", "CGDCOND"),
        AGE_GROUP("AGE GROUP", "CGDAGE"),
        INHERITANCE("INHERITANCE", "CGDINH"),
        GENERALIZED_INHERITANCE("", "CGDGIN");

        private final String cgdName;
        private final String attributeName;
        private static Map<String, String> mappings;

        private CGDAttributeName(String cgdName, String attributeName) {
            this.cgdName = cgdName;
            this.attributeName = attributeName;
        }

        public static String getCgdName(String attributeName) {
            if (mappings.isEmpty()) {
                for (CGDAttributeName enumValue : CGDAttributeName.values()) {
                    mappings.put(enumValue.getAttributeName(), enumValue.getCgdName());
                }
            }
            return mappings.get(attributeName);
        }

        public String getCgdName() {
            return this.cgdName;
        }

        public String getAttributeName() {
            return this.attributeName;
        }

        static {
            mappings = new HashMap<String, String>();
        }
    }

    public static enum GeneralizedInheritance {
        DOM_OR_REC,
        DOMINANT,
        RECESSIVE,
        XLINKED,
        OTHER;

    }
}

