/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.annotation.core.entity.impl;

import java.util.ArrayList;
import java.util.List;
import org.molgenis.data.DataService;
import org.molgenis.data.Entity;
import org.molgenis.data.annotation.core.RepositoryAnnotator;
import org.molgenis.data.annotation.core.entity.AnnotatorConfig;
import org.molgenis.data.annotation.core.entity.AnnotatorInfo;
import org.molgenis.data.annotation.core.entity.impl.framework.AbstractAnnotator;
import org.molgenis.data.annotation.core.entity.impl.framework.RepositoryAnnotatorImpl;
import org.molgenis.data.annotation.core.filter.MultiAllelicResultFilter;
import org.molgenis.data.annotation.core.query.LocusQueryCreator;
import org.molgenis.data.annotation.core.resources.Resource;
import org.molgenis.data.annotation.core.resources.Resources;
import org.molgenis.data.annotation.core.resources.impl.RepositoryFactory;
import org.molgenis.data.annotation.core.resources.impl.ResourceImpl;
import org.molgenis.data.annotation.core.resources.impl.SingleResourceConfig;
import org.molgenis.data.annotation.core.resources.impl.tabix.TabixRepositoryFactory;
import org.molgenis.data.annotation.web.settings.SingleFileLocationCmdLineAnnotatorSettingsConfigurer;
import org.molgenis.data.meta.AttributeType;
import org.molgenis.data.meta.model.Attribute;
import org.molgenis.data.meta.model.AttributeFactory;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.data.meta.model.EntityTypeFactory;
import org.molgenis.data.vcf.model.VcfAttributes;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class CaddAnnotator
implements AnnotatorConfig {
    public static final String NAME = "cadd";
    public static final String CADD_SCALED = "CADD_SCALED";
    public static final String CADD_ABS = "CADD";
    public static final String CADD_SCALED_LABEL = "CADDSCALED";
    public static final String CADD_ABS_LABEL = "CADDABS";
    public static final String CADD_TABIX_RESOURCE = "CADDTabixResource";
    @Autowired
    private Entity caddAnnotatorSettings;
    @Autowired
    private Resources resources;
    @Autowired
    private DataService dataService;
    @Autowired
    private VcfAttributes vcfAttributes;
    @Autowired
    private EntityTypeFactory entityTypeFactory;
    @Autowired
    private AttributeFactory attributeFactory;
    private RepositoryAnnotatorImpl annotator;

    @Bean
    public RepositoryAnnotator cadd() {
        this.annotator = new RepositoryAnnotatorImpl(NAME);
        return this.annotator;
    }

    @Override
    public void init() {
        List<Attribute> attributes = this.createCaddAnnotatorAttributes();
        AnnotatorInfo caddInfo = AnnotatorInfo.create(AnnotatorInfo.Status.READY, AnnotatorInfo.Type.PATHOGENICITY_ESTIMATE, NAME, "CADD is a tool for scoring the deleteriousness of single nucleotide variants as well as insertion/deletions variants in the human genome.\nWhile many variant annotation and scoring utils are around, most annotations tend to exploit a single information type (e.g. conservation) and/or are restricted in scope (e.g. to missense changes). Thus, a broadly applicable metric that objectively weights and integrates diverse information is needed. Combined Annotation Dependent Depletion (CADD) is a framework that integrates multiple annotations into one metric by contrasting variants that survived natural selection with simulated mutations.\nC-scores strongly correlate with allelic diversity, pathogenicity of both coding and non-coding variants, and experimentally measured regulatory effects, and also highly rank causal variants within individual genome sequences. Finally, C-scores of complex trait-associated variants from genome-wide association studies (GWAS) are significantly higher than matched controls and correlate with study sample size, likely reflecting the increased accuracy of larger GWAS.\nCADD can quantitatively prioritize functional, deleterious, and disease causal variants across a wide range of functional categories, effect sizes and genetic architectures and can be used prioritize causal variation in both research and clinical settings. (source: http://cadd.gs.washington.edu/info)", attributes);
        AbstractAnnotator entityAnnotator = new AbstractAnnotator(CADD_TABIX_RESOURCE, caddInfo, new LocusQueryCreator(this.vcfAttributes), new MultiAllelicResultFilter(attributes, true, this.vcfAttributes), this.dataService, this.resources, new SingleFileLocationCmdLineAnnotatorSettingsConfigurer("caddLocation", this.caddAnnotatorSettings)){

            @Override
            public List<Attribute> createAnnotatorAttributes(AttributeFactory attributeFactory) {
                return CaddAnnotator.this.createCaddAnnotatorAttributes();
            }
        };
        this.annotator.init(entityAnnotator);
    }

    private List<Attribute> createCaddAnnotatorAttributes() {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        Attribute cadd_abs = CaddAnnotator.createCaddAbsAttr(this.attributeFactory);
        Attribute cadd_scaled = CaddAnnotator.createCaddScaledAttr(this.attributeFactory);
        attributes.add(cadd_abs);
        attributes.add(cadd_scaled);
        return attributes;
    }

    public static Attribute createCaddScaledAttr(AttributeFactory attributeFactory) {
        return attributeFactory.create().setName(CADD_SCALED).setDataType(AttributeType.STRING).setDescription("Since the raw scores do have relative meaning, one can take a specific group of variants, define the rank for each variant within that group, and then use that value as a \"normalized\" and now externally comparable unit of analysis. In our case, we scored and ranked all ~8.6 billion SNVs of the GRCh37/hg19 reference and then \"PHRED-scaled\" those values by expressing the rank in order of magnitude terms rather than the precise rank itself. For example, reference genome single nucleotide variants at the 10th-% of CADD scores are assigned to CADD-10, top 1% to CADD-20, top 0.1% to CADD-30, etc. The results of this transformation are the \"scaled\" CADD scores.(source: http://cadd.gs.washington.edu/info)").setLabel(CADD_SCALED_LABEL);
    }

    static Attribute createCaddAbsAttr(AttributeFactory attributeFactory) {
        return attributeFactory.create().setName(CADD_ABS).setDataType(AttributeType.STRING).setDescription("\"Raw\" CADD scores come straight from the model, and are interpretable as the extent to which the annotation profile for a given variant suggests that that variant is likely to be \"observed\" (negative values) vs \"simulated\" (positive values). These values have no absolute unit of meaning and are incomparable across distinct annotation combinations, training sets, or model parameters. However, raw values do have relative meaning, with higher values indicating that a variant is more likely to be simulated (or \"not observed\") and therefore more likely to have deleterious effects.(source: http://cadd.gs.washington.edu/info)").setLabel(CADD_ABS_LABEL);
    }

    @Bean
    Resource caddResource() {
        return new ResourceImpl(CADD_TABIX_RESOURCE, new SingleResourceConfig("caddLocation", this.caddAnnotatorSettings)){

            @Override
            public RepositoryFactory getRepositoryFactory() {
                String idAttrName = "id";
                EntityType repoMetaData = (EntityType)CaddAnnotator.this.entityTypeFactory.create((Object)CaddAnnotator.CADD_TABIX_RESOURCE);
                repoMetaData.addAttribute(CaddAnnotator.this.vcfAttributes.getChromAttribute(), new EntityType.AttributeRole[0]);
                repoMetaData.addAttribute(CaddAnnotator.this.vcfAttributes.getPosAttribute(), new EntityType.AttributeRole[0]);
                repoMetaData.addAttribute(CaddAnnotator.this.vcfAttributes.getRefAttribute(), new EntityType.AttributeRole[0]);
                repoMetaData.addAttribute(CaddAnnotator.this.vcfAttributes.getAltAttribute(), new EntityType.AttributeRole[0]);
                repoMetaData.addAttribute(CaddAnnotator.this.attributeFactory.create().setName(CaddAnnotator.CADD_ABS).setDataType(AttributeType.STRING), new EntityType.AttributeRole[0]);
                repoMetaData.addAttribute(CaddAnnotator.this.attributeFactory.create().setName(CaddAnnotator.CADD_SCALED).setDataType(AttributeType.STRING), new EntityType.AttributeRole[0]);
                Attribute idAttribute = CaddAnnotator.this.attributeFactory.create().setName(idAttrName).setVisible(false).setIdAttribute(Boolean.valueOf(true));
                repoMetaData.addAttribute(idAttribute, new EntityType.AttributeRole[0]);
                return new TabixRepositoryFactory(repoMetaData);
            }
        };
    }
}

