/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.annotation.core.entity.impl;

import java.util.ArrayList;
import java.util.List;
import org.molgenis.data.DataService;
import org.molgenis.data.Entity;
import org.molgenis.data.annotation.core.RepositoryAnnotator;
import org.molgenis.data.annotation.core.entity.AnnotatorConfig;
import org.molgenis.data.annotation.core.entity.AnnotatorInfo;
import org.molgenis.data.annotation.core.entity.impl.framework.AbstractAnnotator;
import org.molgenis.data.annotation.core.entity.impl.framework.RepositoryAnnotatorImpl;
import org.molgenis.data.annotation.core.filter.MultiAllelicResultFilter;
import org.molgenis.data.annotation.core.query.LocusQueryCreator;
import org.molgenis.data.annotation.core.resources.Resource;
import org.molgenis.data.annotation.core.resources.Resources;
import org.molgenis.data.annotation.core.resources.impl.RepositoryFactory;
import org.molgenis.data.annotation.core.resources.impl.ResourceImpl;
import org.molgenis.data.annotation.core.resources.impl.SingleResourceConfig;
import org.molgenis.data.annotation.core.resources.impl.tabix.TabixRepositoryFactory;
import org.molgenis.data.annotation.web.settings.SingleFileLocationCmdLineAnnotatorSettingsConfigurer;
import org.molgenis.data.meta.AttributeType;
import org.molgenis.data.meta.model.Attribute;
import org.molgenis.data.meta.model.AttributeFactory;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.data.meta.model.EntityTypeFactory;
import org.molgenis.data.vcf.model.VcfAttributes;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class DannAnnotator
implements AnnotatorConfig {
    public static final String NAME = "dann";
    public static final String DANN_SCORE = "DANN_SCORE";
    public static final String DANN_SCORE_LABEL = "DANNSCORE";
    public static final String DANN_TABIX_RESOURCE = "DANNTabixResource";
    @Autowired
    private Entity dannAnnotatorSettings;
    @Autowired
    private DataService dataService;
    @Autowired
    private Resources resources;
    @Autowired
    private VcfAttributes vcfAttributes;
    @Autowired
    private EntityTypeFactory entityTypeFactory;
    @Autowired
    private AttributeFactory attributeFactory;
    private RepositoryAnnotatorImpl annotator;

    @Bean
    public RepositoryAnnotator dann() {
        this.annotator = new RepositoryAnnotatorImpl(NAME);
        return this.annotator;
    }

    @Override
    public void init() {
        List<Attribute> attributes = this.createDannOutputAttributes();
        AnnotatorInfo dannInfo = AnnotatorInfo.create(AnnotatorInfo.Status.READY, AnnotatorInfo.Type.PATHOGENICITY_ESTIMATE, NAME, "Annotating genetic variants, especially non-coding variants, for the purpose of identifying pathogenic variants remains a challenge. Combined annotation-dependent depletion (CADD) is an al- gorithm designed to annotate both coding and non-coding variants, and has been shown to outper- form other annotation algorithms. CADD trains a linear kernel support vector machine (SVM) to dif- ferentiate evolutionarily derived, likely benign, alleles from simulated, likely deleterious, variants. However, SVMs cannot capture non-linear relationships among the features, which can limit performance. To address this issue, we have developed DANN. DANN uses the same feature set and training data as CADD to train a deep neural network (DNN). DNNs can capture non-linear relation- ships among features and are better suited than SVMs for problems with a large number of samples and features. We exploit Compute Unified Device Architecture-compatible graphics processing units and deep learning techniques such as dropout and momentum training to accelerate the DNN training. DANN achieves about a 19%relative reduction in the error rate and about a 14%relative increase in the area under the curve (AUC) metric over CADD\u2019s SVM methodology. All data and source code are available at https://cbcl.ics.uci.edu/ public_data/DANN/.", attributes);
        AbstractAnnotator entityAnnotator = new AbstractAnnotator(DANN_TABIX_RESOURCE, dannInfo, new LocusQueryCreator(this.vcfAttributes), new MultiAllelicResultFilter(attributes, this.vcfAttributes), this.dataService, this.resources, new SingleFileLocationCmdLineAnnotatorSettingsConfigurer("dannLocation", this.dannAnnotatorSettings)){

            @Override
            public List<Attribute> createAnnotatorAttributes(AttributeFactory attributeFactory) {
                return DannAnnotator.this.createDannOutputAttributes();
            }
        };
        this.annotator.init(entityAnnotator);
    }

    private List<Attribute> createDannOutputAttributes() {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        Attribute dann_score = this.attributeFactory.create().setName(DANN_SCORE).setDataType(AttributeType.STRING).setDescription("deleterious score of genetic variants using neural networks.").setLabel(DANN_SCORE_LABEL);
        attributes.add(dann_score);
        return attributes;
    }

    @Bean
    Resource dannResource() {
        ResourceImpl dannTabixResource = new ResourceImpl(DANN_TABIX_RESOURCE, new SingleResourceConfig("dannLocation", this.dannAnnotatorSettings)){

            @Override
            public RepositoryFactory getRepositoryFactory() {
                String idAttrName = "id";
                EntityType repoMetaData = (EntityType)DannAnnotator.this.entityTypeFactory.create((Object)DannAnnotator.DANN_TABIX_RESOURCE);
                repoMetaData.addAttribute(DannAnnotator.this.vcfAttributes.getChromAttribute(), new EntityType.AttributeRole[0]);
                repoMetaData.addAttribute(DannAnnotator.this.vcfAttributes.getPosAttribute(), new EntityType.AttributeRole[0]);
                repoMetaData.addAttribute(DannAnnotator.this.vcfAttributes.getRefAttribute(), new EntityType.AttributeRole[0]);
                repoMetaData.addAttribute(DannAnnotator.this.vcfAttributes.getAltAttribute(), new EntityType.AttributeRole[0]);
                repoMetaData.addAttribute(DannAnnotator.this.attributeFactory.create().setName(DannAnnotator.DANN_SCORE).setDataType(AttributeType.STRING), new EntityType.AttributeRole[0]);
                Attribute idAttribute = DannAnnotator.this.attributeFactory.create().setName(idAttrName).setVisible(false).setIdAttribute(Boolean.valueOf(true));
                repoMetaData.addAttribute(idAttribute, new EntityType.AttributeRole[0]);
                return new TabixRepositoryFactory(repoMetaData);
            }
        };
        return dannTabixResource;
    }
}

