/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.annotation.core.entity.impl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.molgenis.data.DataService;
import org.molgenis.data.Entity;
import org.molgenis.data.annotation.core.RepositoryAnnotator;
import org.molgenis.data.annotation.core.entity.AnnotatorConfig;
import org.molgenis.data.annotation.core.entity.AnnotatorInfo;
import org.molgenis.data.annotation.core.entity.impl.framework.AbstractAnnotator;
import org.molgenis.data.annotation.core.entity.impl.framework.RepositoryAnnotatorImpl;
import org.molgenis.data.annotation.core.filter.MultiAllelicResultFilter;
import org.molgenis.data.annotation.core.query.LocusQueryCreator;
import org.molgenis.data.annotation.core.resources.Resource;
import org.molgenis.data.annotation.core.resources.Resources;
import org.molgenis.data.annotation.core.resources.impl.RepositoryFactory;
import org.molgenis.data.annotation.core.resources.impl.ResourceImpl;
import org.molgenis.data.annotation.core.resources.impl.SingleResourceConfig;
import org.molgenis.data.annotation.core.resources.impl.tabix.TabixVcfRepositoryFactory;
import org.molgenis.data.annotation.web.settings.SingleFileLocationCmdLineAnnotatorSettingsConfigurer;
import org.molgenis.data.meta.AttributeType;
import org.molgenis.data.meta.model.Attribute;
import org.molgenis.data.meta.model.AttributeFactory;
import org.molgenis.data.meta.model.EntityTypeFactory;
import org.molgenis.data.vcf.model.VcfAttributes;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ExacAnnotator
implements AnnotatorConfig {
    public static final String NAME = "exac";
    public static final String EXAC_AF = "EXAC_AF";
    public static final String EXAC_AC_HOM = "EXAC_AC_HOM";
    public static final String EXAC_AC_HET = "EXAC_AC_HET";
    public static final String EXAC_AF_LABEL = "ExAC allele frequency";
    public static final String EXAC_AC_HOM_LABEL = "ExAC homozygous alternative genotype count";
    public static final String EXAC_AC_HET_LABEL = "ExAC heterozygous genotype count";
    public static final String EXAC_AF_ResourceAttributeName = "AF";
    public static final String EXAC_AC_HOM_ResourceAttributeName = "AC_Hom";
    public static final String EXAC_AC_HET_ResourceAttributeName = "AC_Het";
    public static final String EXAC_TABIX_RESOURCE = "EXACTabixResource";
    @Autowired
    private Entity exacAnnotatorSettings;
    @Autowired
    private DataService dataService;
    @Autowired
    private Resources resources;
    @Autowired
    private VcfAttributes vcfAttributes;
    @Autowired
    private EntityTypeFactory entityTypeFactory;
    @Autowired
    private AttributeFactory attributeFactory;
    private RepositoryAnnotatorImpl annotator;

    @Bean
    public RepositoryAnnotator exac() {
        this.annotator = new RepositoryAnnotatorImpl(NAME);
        return this.annotator;
    }

    @Override
    public void init() {
        List<Attribute> attributes = this.createExacOutputAttributes();
        ArrayList<Attribute> resourceMetaData = new ArrayList<Attribute>(Arrays.asList(this.attributeFactory.create().setName(EXAC_AF_ResourceAttributeName).setDataType(AttributeType.STRING), this.attributeFactory.create().setName(EXAC_AC_HOM_ResourceAttributeName).setDataType(AttributeType.STRING), this.attributeFactory.create().setName(EXAC_AC_HET_ResourceAttributeName).setDataType(AttributeType.STRING)));
        AnnotatorInfo exacInfo = AnnotatorInfo.create(AnnotatorInfo.Status.READY, AnnotatorInfo.Type.POPULATION_REFERENCE, NAME, " The Exome Aggregation Consortium (ExAC) is a coalition of investigators seeking to aggregate and harmonize exome sequencing data from a wide variety of large-scale sequencing projects, and to make summary data available for the wider scientific community.The data set provided on this website spans 60,706 unrelated individuals sequenced as part of various disease-specific and population genetic studies. ", attributes);
        LocusQueryCreator locusQueryCreator = new LocusQueryCreator(this.vcfAttributes);
        MultiAllelicResultFilter multiAllelicResultFilter = new MultiAllelicResultFilter(resourceMetaData, this.vcfAttributes);
        AbstractAnnotator entityAnnotator = new AbstractAnnotator(EXAC_TABIX_RESOURCE, exacInfo, locusQueryCreator, multiAllelicResultFilter, this.dataService, this.resources, new SingleFileLocationCmdLineAnnotatorSettingsConfigurer("exacLocation", this.exacAnnotatorSettings)){

            @Override
            public List<Attribute> createAnnotatorAttributes(AttributeFactory attributeFactory) {
                return ExacAnnotator.this.createExacOutputAttributes();
            }

            @Override
            protected Object getResourceAttributeValue(Attribute attr, Entity sourceEntity) {
                String attrName = ExacAnnotator.EXAC_AF.equals(attr.getName()) ? ExacAnnotator.EXAC_AF_ResourceAttributeName : (ExacAnnotator.EXAC_AC_HOM.equals(attr.getName()) ? ExacAnnotator.EXAC_AC_HOM_ResourceAttributeName : (ExacAnnotator.EXAC_AC_HET.equals(attr.getName()) ? ExacAnnotator.EXAC_AC_HET_ResourceAttributeName : attr.getName()));
                return sourceEntity.get(attrName);
            }
        };
        this.annotator.init(entityAnnotator);
    }

    public List<Attribute> createExacOutputAttributes() {
        return Lists.newArrayList((Object[])new Attribute[]{ExacAnnotator.getExacAFAttr(this.attributeFactory), ExacAnnotator.getExacAcHomAttr(this.attributeFactory), ExacAnnotator.getExacAcHetAttr(this.attributeFactory)});
    }

    public static Attribute getExacAcHetAttr(AttributeFactory attributeFactory) {
        return attributeFactory.create().setName(EXAC_AC_HET).setDataType(AttributeType.STRING).setDescription("The ExAC heterozygous genotype count").setLabel(EXAC_AC_HET_LABEL);
    }

    public static Attribute getExacAcHomAttr(AttributeFactory attributeFactory) {
        return attributeFactory.create().setName(EXAC_AC_HOM).setDataType(AttributeType.STRING).setDescription("The ExAC homozygous alternative genotype count").setLabel(EXAC_AC_HOM_LABEL);
    }

    public static Attribute getExacAFAttr(AttributeFactory attributeFactory) {
        return attributeFactory.create().setName(EXAC_AF).setDataType(AttributeType.STRING).setDescription("The ExAC allele frequency").setLabel(EXAC_AF_LABEL);
    }

    @Bean
    Resource exacResource() {
        ResourceImpl exacTabixResource = new ResourceImpl(EXAC_TABIX_RESOURCE, new SingleResourceConfig("exacLocation", this.exacAnnotatorSettings)){

            @Override
            public RepositoryFactory getRepositoryFactory() {
                return new TabixVcfRepositoryFactory(ExacAnnotator.EXAC_TABIX_RESOURCE, ExacAnnotator.this.vcfAttributes, ExacAnnotator.this.entityTypeFactory, ExacAnnotator.this.attributeFactory);
            }
        };
        return exacTabixResource;
    }
}

