/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.annotation.core.entity.impl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.molgenis.data.DataService;
import org.molgenis.data.Entity;
import org.molgenis.data.annotation.core.RepositoryAnnotator;
import org.molgenis.data.annotation.core.entity.AnnotatorConfig;
import org.molgenis.data.annotation.core.entity.AnnotatorInfo;
import org.molgenis.data.annotation.core.entity.impl.framework.AbstractAnnotator;
import org.molgenis.data.annotation.core.entity.impl.framework.RepositoryAnnotatorImpl;
import org.molgenis.data.annotation.core.filter.MultiAllelicResultFilter;
import org.molgenis.data.annotation.core.query.LocusQueryCreator;
import org.molgenis.data.annotation.core.resources.Resource;
import org.molgenis.data.annotation.core.resources.Resources;
import org.molgenis.data.annotation.core.resources.impl.RepositoryFactory;
import org.molgenis.data.annotation.core.resources.impl.ResourceImpl;
import org.molgenis.data.annotation.core.resources.impl.SingleResourceConfig;
import org.molgenis.data.annotation.core.resources.impl.tabix.TabixRepositoryFactory;
import org.molgenis.data.annotation.web.settings.SingleFileLocationCmdLineAnnotatorSettingsConfigurer;
import org.molgenis.data.meta.AttributeType;
import org.molgenis.data.meta.model.Attribute;
import org.molgenis.data.meta.model.AttributeFactory;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.data.meta.model.EntityTypeFactory;
import org.molgenis.data.vcf.model.VcfAttributes;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class FitConAnnotator
implements AnnotatorConfig {
    public static final String NAME = "fitcon";
    public static final String FITCON_SCORE = "FITCON_SCORE";
    public static final String FITCON_SCORE_LABEL = "FITCON_SCORE";
    public static final String FITCON_TABIX_RESOURCE = "FitConTabixResource";
    @Autowired
    private Entity fitConAnnotatorSettings;
    @Autowired
    private DataService dataService;
    @Autowired
    private Resources resources;
    @Autowired
    private VcfAttributes vcfAttributes;
    @Autowired
    private EntityTypeFactory entityTypeFactory;
    @Autowired
    private AttributeFactory attributeFactory;
    private RepositoryAnnotatorImpl annotator;

    @Bean
    public RepositoryAnnotator fitcon() {
        this.annotator = new RepositoryAnnotatorImpl(NAME);
        return this.annotator;
    }

    @Override
    public void init() {
        List<Attribute> attributes = this.createFitconOutputAttributes();
        AnnotatorInfo fitconInfo = AnnotatorInfo.create(AnnotatorInfo.Status.READY, AnnotatorInfo.Type.EFFECT_PREDICTION, NAME, "Summary: Annotating genetic variants, especially non-coding variants, for the purpose of identifying pathogenic variants remains a challenge. Combined annotation-dependent depletion (CADD) is an al- gorithm designed to annotate both coding and non-coding variants, and has been shown to outper- form other annotation algorithms. CADD trains a linear kernel support vector machine (SVM) to dif- ferentiate evolutionarily derived, likely benign, alleles from simulated, likely deleterious, variants. However, SVMs cannot capture non-linear relationships among the features, which can limit per- formance. To address this issue, we have developed FITCON. FITCON uses the same feature set and training data as CADD to train a deep neural network (DNN). DNNs can capture non-linear relation- ships among features and are better suited than SVMs for problems with a large number of samples and features. We exploit Compute Unified Device Architecture-compatible graphics processing units and deep learning techniques such as dropout and momentum training to accelerate the DNN train- ing. FITCON achieves about a 19%relative reduction in the error rate and about a 14%relative increase in the area under the curve (AUC) metric over CADD\u2019s SVMmethodology. All data and source code are available at https://cbcl.ics.uci.edu/ public_data/FITCON/. Contact:", attributes);
        AbstractAnnotator entityAnnotator = new AbstractAnnotator(FITCON_TABIX_RESOURCE, fitconInfo, new LocusQueryCreator(this.vcfAttributes), new MultiAllelicResultFilter(attributes, this.vcfAttributes), this.dataService, this.resources, new SingleFileLocationCmdLineAnnotatorSettingsConfigurer("fitconLocation", this.fitConAnnotatorSettings)){

            @Override
            public List<Attribute> createAnnotatorAttributes(AttributeFactory attributeFactory) {
                return FitConAnnotator.this.createFitconOutputAttributes();
            }
        };
        this.annotator.init(entityAnnotator);
    }

    private List<Attribute> createFitconOutputAttributes() {
        ArrayList attributes = Lists.newArrayList();
        Attribute fitcon_score = this.attributeFactory.create().setName("FITCON_SCORE").setDataType(AttributeType.STRING).setDescription("fitness consequence score annotation of genetic variants using Fitcon scoring.").setLabel("FITCON_SCORE");
        attributes.add(fitcon_score);
        return attributes;
    }

    @Bean
    Resource fitconResource() {
        ResourceImpl fitConTabixResource = new ResourceImpl(FITCON_TABIX_RESOURCE, new SingleResourceConfig("fitconLocation", this.fitConAnnotatorSettings)){

            @Override
            public RepositoryFactory getRepositoryFactory() {
                EntityType repoMetaData = (EntityType)FitConAnnotator.this.entityTypeFactory.create((Object)FitConAnnotator.FITCON_TABIX_RESOURCE);
                repoMetaData.addAttribute(FitConAnnotator.this.vcfAttributes.getChromAttribute(), new EntityType.AttributeRole[0]);
                repoMetaData.addAttribute(FitConAnnotator.this.vcfAttributes.getPosAttribute(), new EntityType.AttributeRole[0]);
                repoMetaData.addAttribute(FitConAnnotator.this.vcfAttributes.getRefAttribute(), new EntityType.AttributeRole[0]);
                repoMetaData.addAttribute(FitConAnnotator.this.attributeFactory.create().setName("Anc"), new EntityType.AttributeRole[0]);
                repoMetaData.addAttribute(FitConAnnotator.this.vcfAttributes.getAltAttribute(), new EntityType.AttributeRole[0]);
                repoMetaData.addAttribute(FitConAnnotator.this.attributeFactory.create().setName("Type"), new EntityType.AttributeRole[0]);
                repoMetaData.addAttribute(FitConAnnotator.this.attributeFactory.create().setName("Length"), new EntityType.AttributeRole[0]);
                repoMetaData.addAttribute(FitConAnnotator.this.attributeFactory.create().setName("isTv"), new EntityType.AttributeRole[0]);
                repoMetaData.addAttribute(FitConAnnotator.this.attributeFactory.create().setName("isDerived"), new EntityType.AttributeRole[0]);
                repoMetaData.addAttribute(FitConAnnotator.this.attributeFactory.create().setName("AnnoType"), new EntityType.AttributeRole[0]);
                repoMetaData.addAttribute(FitConAnnotator.this.attributeFactory.create().setName("Consequence"), new EntityType.AttributeRole[0]);
                repoMetaData.addAttribute(FitConAnnotator.this.attributeFactory.create().setName("ConsScore"), new EntityType.AttributeRole[0]);
                repoMetaData.addAttribute(FitConAnnotator.this.attributeFactory.create().setName("ConsDetail"), new EntityType.AttributeRole[0]);
                repoMetaData.addAttribute(FitConAnnotator.this.attributeFactory.create().setName("GC"), new EntityType.AttributeRole[0]);
                repoMetaData.addAttribute(FitConAnnotator.this.attributeFactory.create().setName("CpG"), new EntityType.AttributeRole[0]);
                repoMetaData.addAttribute(FitConAnnotator.this.attributeFactory.create().setName("mapAbility20bp"), new EntityType.AttributeRole[0]);
                repoMetaData.addAttribute(FitConAnnotator.this.attributeFactory.create().setName("mapAbility35bp"), new EntityType.AttributeRole[0]);
                repoMetaData.addAttribute(FitConAnnotator.this.attributeFactory.create().setName("scoreSegDup"), new EntityType.AttributeRole[0]);
                repoMetaData.addAttribute(FitConAnnotator.this.attributeFactory.create().setName("priPhCons"), new EntityType.AttributeRole[0]);
                repoMetaData.addAttribute(FitConAnnotator.this.attributeFactory.create().setName("mamPhCons"), new EntityType.AttributeRole[0]);
                repoMetaData.addAttribute(FitConAnnotator.this.attributeFactory.create().setName("verPhCons"), new EntityType.AttributeRole[0]);
                repoMetaData.addAttribute(FitConAnnotator.this.attributeFactory.create().setName("priPhyloP"), new EntityType.AttributeRole[0]);
                repoMetaData.addAttribute(FitConAnnotator.this.attributeFactory.create().setName("mamPhyloP"), new EntityType.AttributeRole[0]);
                repoMetaData.addAttribute(FitConAnnotator.this.attributeFactory.create().setName("verPhyloP"), new EntityType.AttributeRole[0]);
                repoMetaData.addAttribute(FitConAnnotator.this.attributeFactory.create().setName("GerpN"), new EntityType.AttributeRole[0]);
                repoMetaData.addAttribute(FitConAnnotator.this.attributeFactory.create().setName("GerpS"), new EntityType.AttributeRole[0]);
                repoMetaData.addAttribute(FitConAnnotator.this.attributeFactory.create().setName("GerpRS"), new EntityType.AttributeRole[0]);
                repoMetaData.addAttribute(FitConAnnotator.this.attributeFactory.create().setName("GerpRSpval"), new EntityType.AttributeRole[0]);
                repoMetaData.addAttribute(FitConAnnotator.this.attributeFactory.create().setName("bStatistic"), new EntityType.AttributeRole[0]);
                repoMetaData.addAttribute(FitConAnnotator.this.attributeFactory.create().setName("mutIndex"), new EntityType.AttributeRole[0]);
                repoMetaData.addAttribute(FitConAnnotator.this.attributeFactory.create().setName("dnaHelT"), new EntityType.AttributeRole[0]);
                repoMetaData.addAttribute(FitConAnnotator.this.attributeFactory.create().setName("dnaMGW"), new EntityType.AttributeRole[0]);
                repoMetaData.addAttribute(FitConAnnotator.this.attributeFactory.create().setName("dnaProT"), new EntityType.AttributeRole[0]);
                repoMetaData.addAttribute(FitConAnnotator.this.attributeFactory.create().setName("dnaRoll"), new EntityType.AttributeRole[0]);
                repoMetaData.addAttribute(FitConAnnotator.this.attributeFactory.create().setName("mirSVR-Score"), new EntityType.AttributeRole[0]);
                repoMetaData.addAttribute(FitConAnnotator.this.attributeFactory.create().setName("mirSVR-E"), new EntityType.AttributeRole[0]);
                repoMetaData.addAttribute(FitConAnnotator.this.attributeFactory.create().setName("mirSVR-Aln"), new EntityType.AttributeRole[0]);
                repoMetaData.addAttribute(FitConAnnotator.this.attributeFactory.create().setName("targetScan"), new EntityType.AttributeRole[0]);
                repoMetaData.addAttribute(FitConAnnotator.this.attributeFactory.create().setName("FITCON_SCORE"), new EntityType.AttributeRole[0]);
                repoMetaData.addAttribute(FitConAnnotator.this.attributeFactory.create().setName("cHmmTssA"), new EntityType.AttributeRole[0]);
                repoMetaData.addAttribute(FitConAnnotator.this.attributeFactory.create().setName("cHmmTssAFlnk"), new EntityType.AttributeRole[0]);
                repoMetaData.addAttribute(FitConAnnotator.this.attributeFactory.create().setName("cHmmTxFlnk"), new EntityType.AttributeRole[0]);
                repoMetaData.addAttribute(FitConAnnotator.this.attributeFactory.create().setName("cHmmTx"), new EntityType.AttributeRole[0]);
                repoMetaData.addAttribute(FitConAnnotator.this.attributeFactory.create().setName("cHmmTxWk"), new EntityType.AttributeRole[0]);
                repoMetaData.addAttribute(FitConAnnotator.this.attributeFactory.create().setName("cHmmEnhG"), new EntityType.AttributeRole[0]);
                repoMetaData.addAttribute(FitConAnnotator.this.attributeFactory.create().setName("cHmmEnh"), new EntityType.AttributeRole[0]);
                repoMetaData.addAttribute(FitConAnnotator.this.attributeFactory.create().setName("cHmmZnfRpts"), new EntityType.AttributeRole[0]);
                repoMetaData.addAttribute(FitConAnnotator.this.attributeFactory.create().setName("cHmmHet"), new EntityType.AttributeRole[0]);
                repoMetaData.addAttribute(FitConAnnotator.this.attributeFactory.create().setName("cHmmTssBiv"), new EntityType.AttributeRole[0]);
                repoMetaData.addAttribute(FitConAnnotator.this.attributeFactory.create().setName("cHmmBivFlnk"), new EntityType.AttributeRole[0]);
                repoMetaData.addAttribute(FitConAnnotator.this.attributeFactory.create().setName("cHmmEnhBiv"), new EntityType.AttributeRole[0]);
                repoMetaData.addAttribute(FitConAnnotator.this.attributeFactory.create().setName("cHmmReprPC"), new EntityType.AttributeRole[0]);
                repoMetaData.addAttribute(FitConAnnotator.this.attributeFactory.create().setName("cHmmReprPCWk"), new EntityType.AttributeRole[0]);
                repoMetaData.addAttribute(FitConAnnotator.this.attributeFactory.create().setName("cHmmQuies"), new EntityType.AttributeRole[0]);
                repoMetaData.addAttribute(FitConAnnotator.this.attributeFactory.create().setName("EncExp"), new EntityType.AttributeRole[0]);
                repoMetaData.addAttribute(FitConAnnotator.this.attributeFactory.create().setName("EncH3K27Ac"), new EntityType.AttributeRole[0]);
                repoMetaData.addAttribute(FitConAnnotator.this.attributeFactory.create().setName("EncH3K4Me1"), new EntityType.AttributeRole[0]);
                repoMetaData.addAttribute(FitConAnnotator.this.attributeFactory.create().setName("EncH3K4Me3"), new EntityType.AttributeRole[0]);
                repoMetaData.addAttribute(FitConAnnotator.this.attributeFactory.create().setName("EncNucleo"), new EntityType.AttributeRole[0]);
                repoMetaData.addAttribute(FitConAnnotator.this.attributeFactory.create().setName("EncOCC"), new EntityType.AttributeRole[0]);
                repoMetaData.addAttribute(FitConAnnotator.this.attributeFactory.create().setName("EncOCCombPVal"), new EntityType.AttributeRole[0]);
                repoMetaData.addAttribute(FitConAnnotator.this.attributeFactory.create().setName("EncOCDNasePVal"), new EntityType.AttributeRole[0]);
                repoMetaData.addAttribute(FitConAnnotator.this.attributeFactory.create().setName("EncOCFairePVal"), new EntityType.AttributeRole[0]);
                repoMetaData.addAttribute(FitConAnnotator.this.attributeFactory.create().setName("EncOCpolIIPVal"), new EntityType.AttributeRole[0]);
                repoMetaData.addAttribute(FitConAnnotator.this.attributeFactory.create().setName("EncOCctcfPVal"), new EntityType.AttributeRole[0]);
                repoMetaData.addAttribute(FitConAnnotator.this.attributeFactory.create().setName("EncOCmycPVal"), new EntityType.AttributeRole[0]);
                repoMetaData.addAttribute(FitConAnnotator.this.attributeFactory.create().setName("EncOCDNaseSig"), new EntityType.AttributeRole[0]);
                repoMetaData.addAttribute(FitConAnnotator.this.attributeFactory.create().setName("EncOCFaireSig"), new EntityType.AttributeRole[0]);
                repoMetaData.addAttribute(FitConAnnotator.this.attributeFactory.create().setName("EncOCpolIISig"), new EntityType.AttributeRole[0]);
                repoMetaData.addAttribute(FitConAnnotator.this.attributeFactory.create().setName("EncOCctcfSig"), new EntityType.AttributeRole[0]);
                repoMetaData.addAttribute(FitConAnnotator.this.attributeFactory.create().setName("EncOCmycSig"), new EntityType.AttributeRole[0]);
                repoMetaData.addAttribute(FitConAnnotator.this.attributeFactory.create().setName("Segway"), new EntityType.AttributeRole[0]);
                repoMetaData.addAttribute(FitConAnnotator.this.attributeFactory.create().setName("tOverlapMotifs"), new EntityType.AttributeRole[0]);
                repoMetaData.addAttribute(FitConAnnotator.this.attributeFactory.create().setName("motifDist"), new EntityType.AttributeRole[0]);
                repoMetaData.addAttribute(FitConAnnotator.this.attributeFactory.create().setName("motifECount"), new EntityType.AttributeRole[0]);
                repoMetaData.addAttribute(FitConAnnotator.this.attributeFactory.create().setName("motifEName"), new EntityType.AttributeRole[0]);
                repoMetaData.addAttribute(FitConAnnotator.this.attributeFactory.create().setName("motifEHIPos"), new EntityType.AttributeRole[0]);
                repoMetaData.addAttribute(FitConAnnotator.this.attributeFactory.create().setName("motifEScoreChng"), new EntityType.AttributeRole[0]);
                repoMetaData.addAttribute(FitConAnnotator.this.attributeFactory.create().setName("TFBS"), new EntityType.AttributeRole[0]);
                repoMetaData.addAttribute(FitConAnnotator.this.attributeFactory.create().setName("TFBSPeaks"), new EntityType.AttributeRole[0]);
                repoMetaData.addAttribute(FitConAnnotator.this.attributeFactory.create().setName("TFBSPeaksMax"), new EntityType.AttributeRole[0]);
                repoMetaData.addAttribute(FitConAnnotator.this.attributeFactory.create().setName("isKnownVariant"), new EntityType.AttributeRole[0]);
                repoMetaData.addAttribute(FitConAnnotator.this.attributeFactory.create().setName("ESP_AF"), new EntityType.AttributeRole[0]);
                repoMetaData.addAttribute(FitConAnnotator.this.attributeFactory.create().setName("ESP_AFR"), new EntityType.AttributeRole[0]);
                repoMetaData.addAttribute(FitConAnnotator.this.attributeFactory.create().setName("ESP_EUR"), new EntityType.AttributeRole[0]);
                repoMetaData.addAttribute(FitConAnnotator.this.attributeFactory.create().setName("TG_AF"), new EntityType.AttributeRole[0]);
                repoMetaData.addAttribute(FitConAnnotator.this.attributeFactory.create().setName("TG_ASN"), new EntityType.AttributeRole[0]);
                repoMetaData.addAttribute(FitConAnnotator.this.attributeFactory.create().setName("TG_AMR"), new EntityType.AttributeRole[0]);
                repoMetaData.addAttribute(FitConAnnotator.this.attributeFactory.create().setName("TG_AFR"), new EntityType.AttributeRole[0]);
                repoMetaData.addAttribute(FitConAnnotator.this.attributeFactory.create().setName("TG_EUR"), new EntityType.AttributeRole[0]);
                repoMetaData.addAttribute(FitConAnnotator.this.attributeFactory.create().setName("minDistTSS"), new EntityType.AttributeRole[0]);
                repoMetaData.addAttribute(FitConAnnotator.this.attributeFactory.create().setName("minDistTSE"), new EntityType.AttributeRole[0]);
                repoMetaData.addAttribute(FitConAnnotator.this.attributeFactory.create().setName("GeneID"), new EntityType.AttributeRole[0]);
                repoMetaData.addAttribute(FitConAnnotator.this.attributeFactory.create().setName("FeatureID"), new EntityType.AttributeRole[0]);
                repoMetaData.addAttribute(FitConAnnotator.this.attributeFactory.create().setName("CCDS"), new EntityType.AttributeRole[0]);
                repoMetaData.addAttribute(FitConAnnotator.this.attributeFactory.create().setName("GeneName"), new EntityType.AttributeRole[0]);
                repoMetaData.addAttribute(FitConAnnotator.this.attributeFactory.create().setName("cDNApos"), new EntityType.AttributeRole[0]);
                repoMetaData.addAttribute(FitConAnnotator.this.attributeFactory.create().setName("relcDNApos"), new EntityType.AttributeRole[0]);
                repoMetaData.addAttribute(FitConAnnotator.this.attributeFactory.create().setName("CDSpos"), new EntityType.AttributeRole[0]);
                repoMetaData.addAttribute(FitConAnnotator.this.attributeFactory.create().setName("relCDSpos"), new EntityType.AttributeRole[0]);
                repoMetaData.addAttribute(FitConAnnotator.this.attributeFactory.create().setName("protPos"), new EntityType.AttributeRole[0]);
                repoMetaData.addAttribute(FitConAnnotator.this.attributeFactory.create().setName("relProtPos"), new EntityType.AttributeRole[0]);
                repoMetaData.addAttribute(FitConAnnotator.this.attributeFactory.create().setName("Domain"), new EntityType.AttributeRole[0]);
                repoMetaData.addAttribute(FitConAnnotator.this.attributeFactory.create().setName("Dst2Splice"), new EntityType.AttributeRole[0]);
                repoMetaData.addAttribute(FitConAnnotator.this.attributeFactory.create().setName("Dst2SplType"), new EntityType.AttributeRole[0]);
                repoMetaData.addAttribute(FitConAnnotator.this.attributeFactory.create().setName("Exon"), new EntityType.AttributeRole[0]);
                repoMetaData.addAttribute(FitConAnnotator.this.attributeFactory.create().setName("Intron"), new EntityType.AttributeRole[0]);
                repoMetaData.addAttribute(FitConAnnotator.this.attributeFactory.create().setName("oAA"), new EntityType.AttributeRole[0]);
                repoMetaData.addAttribute(FitConAnnotator.this.attributeFactory.create().setName("nAA"), new EntityType.AttributeRole[0]);
                repoMetaData.addAttribute(FitConAnnotator.this.attributeFactory.create().setName("Grantham"), new EntityType.AttributeRole[0]);
                repoMetaData.addAttribute(FitConAnnotator.this.attributeFactory.create().setName("PolyPhenCat"), new EntityType.AttributeRole[0]);
                repoMetaData.addAttribute(FitConAnnotator.this.attributeFactory.create().setName("PolyPhenVal"), new EntityType.AttributeRole[0]);
                repoMetaData.addAttribute(FitConAnnotator.this.attributeFactory.create().setName("SIFTcat"), new EntityType.AttributeRole[0]);
                repoMetaData.addAttribute(FitConAnnotator.this.attributeFactory.create().setName("SIFTval"), new EntityType.AttributeRole[0]);
                repoMetaData.addAttribute(FitConAnnotator.this.attributeFactory.create().setName("RawScore"), new EntityType.AttributeRole[0]);
                repoMetaData.addAttribute(FitConAnnotator.this.attributeFactory.create().setName("PHRED"), new EntityType.AttributeRole[0]);
                Attribute idAttribute = FitConAnnotator.this.attributeFactory.create().setName("id").setVisible(false).setIdAttribute(Boolean.valueOf(true));
                repoMetaData.addAttribute(idAttribute, new EntityType.AttributeRole[0]);
                return new TabixRepositoryFactory(repoMetaData);
            }
        };
        return fitConTabixResource;
    }
}

