/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.annotation.core.entity.impl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.molgenis.data.DataService;
import org.molgenis.data.Entity;
import org.molgenis.data.MolgenisDataException;
import org.molgenis.data.annotation.core.RepositoryAnnotator;
import org.molgenis.data.annotation.core.entity.AnnotatorConfig;
import org.molgenis.data.annotation.core.entity.AnnotatorInfo;
import org.molgenis.data.annotation.core.entity.impl.framework.QueryAnnotatorImpl;
import org.molgenis.data.annotation.core.entity.impl.framework.RepositoryAnnotatorImpl;
import org.molgenis.data.annotation.core.query.LocusQueryCreator;
import org.molgenis.data.annotation.core.resources.Resource;
import org.molgenis.data.annotation.core.resources.Resources;
import org.molgenis.data.annotation.core.resources.impl.MultiFileResource;
import org.molgenis.data.annotation.core.resources.impl.MultiResourceConfigImpl;
import org.molgenis.data.annotation.core.resources.impl.RepositoryFactory;
import org.molgenis.data.annotation.core.resources.impl.tabix.TabixVcfRepositoryFactory;
import org.molgenis.data.meta.AttributeType;
import org.molgenis.data.meta.model.Attribute;
import org.molgenis.data.meta.model.AttributeFactory;
import org.molgenis.data.meta.model.EntityTypeFactory;
import org.molgenis.data.vcf.model.VcfAttributes;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class GoNLAnnotator
implements AnnotatorConfig {
    public static final String NAME = "gonl";
    public static final String GONL_GENOME_AF = "GoNL_AF";
    public static final String GONL_GENOME_GTC = "GoNL_GTC";
    public static final String GONL_AF_LABEL = "Genome of the netherlands allele frequency";
    public static final String GONL_GTC_LABEL = "Genome of the netherlands Genotype counts frequency";
    public static final String INFO_GTC = "GTC";
    public static final String INFO_AN = "AN";
    public static final String INFO_AC = "AC";
    public static final String GONL_MULTI_FILE_RESOURCE = "gonlresources";
    @Autowired
    private Entity goNLAnnotatorSettings;
    @Autowired
    private DataService dataService;
    @Autowired
    private Resources resources;
    @Autowired
    private VcfAttributes vcfAttributes;
    @Autowired
    private AttributeFactory attributeFactory;
    @Autowired
    private EntityTypeFactory entityTypeFactory;
    private RepositoryAnnotatorImpl annotator;

    @Bean
    public RepositoryAnnotator gonl() {
        this.annotator = new RepositoryAnnotatorImpl(NAME);
        return this.annotator;
    }

    @Override
    public void init() {
        List<Attribute> attributes = this.createGoNlOutputAttributes();
        AnnotatorInfo thousandGenomeInfo = AnnotatorInfo.create(AnnotatorInfo.Status.READY, AnnotatorInfo.Type.POPULATION_REFERENCE, NAME, "What genetic variation is to be found in the Dutch indigenous population? Detailed knowledge about this is not only interesting in itself, it also helps to extract useful biomedical information from Dutch biobanks. The Dutch biobank collaboration BBMRI-NL has initiated the extensive Rainbow Project \u201cGenome of the Netherlands\u201d (GoNL) because it offers unique opportunities for science and for the development of new treatments and diagnostic techniques. A close-up look at the DNA of 750 Dutch people-250 trio\u2019s of two parents and an adult child-plus a global genetic profile of large numbers of Dutch will disclose a wealth of new information, new insights, and possible applications.", attributes);
        LocusQueryCreator locusQueryCreator = new LocusQueryCreator(this.vcfAttributes);
        QueryAnnotatorImpl entityAnnotator = new QueryAnnotatorImpl(GONL_MULTI_FILE_RESOURCE, thousandGenomeInfo, locusQueryCreator, this.dataService, this.resources, annotationSourceFileName -> {
            this.goNLAnnotatorSettings.set("rootDirectory", (Object)annotationSourceFileName);
            this.goNLAnnotatorSettings.set("filepattern", (Object)"gonl.chr%s.snps_indels.r5.vcf.gz");
            this.goNLAnnotatorSettings.set("overrideChromosomeFiles", (Object)"X:gonl.chrX.release4.gtc.vcf.gz");
            this.goNLAnnotatorSettings.set("chromosomes", (Object)"1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,X");
        }){

            @Override
            public List<Attribute> createAnnotatorAttributes(AttributeFactory attributeFactory) {
                return GoNLAnnotator.this.createGoNlOutputAttributes();
            }

            @Override
            protected void processQueryResults(Entity entity, Iterable<Entity> annotationSourceEntities, boolean updateMode) {
                if (updateMode) {
                    throw new MolgenisDataException("This annotator/filter does not support updating of values");
                }
                List refMatches = GoNLAnnotator.this.determineRefMatches(entity, annotationSourceEntities);
                GoNLAnnotator.this.setGoNLFrequencies(entity, refMatches);
            }
        };
        this.annotator.init(entityAnnotator);
    }

    private List<Attribute> createGoNlOutputAttributes() {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        Attribute goNlAfAttribute = this.attributeFactory.create().setName(GONL_GENOME_AF).setDataType(AttributeType.STRING).setDescription("The allele frequency for variants seen in the population used for the GoNL project").setLabel(GONL_AF_LABEL);
        Attribute goNlGtcAttribute = this.attributeFactory.create().setName(GONL_GENOME_GTC).setDataType(AttributeType.STRING).setDescription("GenoType Counts. For each ALT allele in the same order as listed = 0/0,0/1,1/1,0/2,1/2,2/2,0/3,1/3,2/3,3/3,etc. Phasing is ignored; hence 1/0, 0|1 and 1|0 are all counted as 0/1. When one or more alleles is not called for a genotype in a specific sample (./., ./0, ./1, ./2, etc.), that sample's genotype is completely discarded for calculating GTC.").setLabel(GONL_GTC_LABEL);
        attributes.add(goNlGtcAttribute);
        attributes.add(goNlAfAttribute);
        return attributes;
    }

    @Bean
    Resource gonlresources() {
        MultiResourceConfigImpl goNLConfig = new MultiResourceConfigImpl("chromosomes", "filepattern", "rootDirectory", "overrideChromosomeFiles", this.goNLAnnotatorSettings);
        return new MultiFileResource(GONL_MULTI_FILE_RESOURCE, goNLConfig){

            @Override
            public RepositoryFactory getRepositoryFactory() {
                return new TabixVcfRepositoryFactory(GoNLAnnotator.GONL_MULTI_FILE_RESOURCE, GoNLAnnotator.this.vcfAttributes, GoNLAnnotator.this.entityTypeFactory, GoNLAnnotator.this.attributeFactory);
            }
        };
    }

    private void setGoNLFrequencies(Entity entity, List<Entity> refMatches) {
        List<Entity> alleleMatches;
        String afs = null;
        String gtcs = null;
        if (this.hasAltAttribute(entity) && (alleleMatches = this.computeAlleleMatches(entity, refMatches)).stream().anyMatch(Objects::nonNull)) {
            afs = alleleMatches.stream().map(gonl -> gonl == null ? "." : Double.toString(Double.valueOf(gonl.getString(INFO_AC)) / (double)gonl.getInt(INFO_AN).intValue())).collect(Collectors.joining(","));
            gtcs = alleleMatches.stream().map(gonl -> gonl == null ? "." : gonl.getString(INFO_GTC).replace(",", "|")).collect(Collectors.joining(","));
        }
        entity.set(GONL_GENOME_AF, afs);
        entity.set(GONL_GENOME_GTC, gtcs);
    }

    private List<Entity> determineRefMatches(Entity entity, Iterable<Entity> annotationSourceEntities) {
        ArrayList refMatches = Lists.newArrayList();
        for (Entity resourceEntity : annotationSourceEntities) {
            if (this.refMatches(resourceEntity)) {
                refMatches.add(resourceEntity);
                continue;
            }
            if (this.shouldLengthenGoNLRef(resourceEntity)) {
                this.lengthenGoNLRef(entity, resourceEntity);
                refMatches.add(resourceEntity);
                continue;
            }
            if (!this.shouldShortenGoNLRef(entity, resourceEntity)) continue;
            this.shortenGoNLRef(entity, resourceEntity);
            refMatches.add(resourceEntity);
        }
        return refMatches;
    }

    private List<Entity> computeAlleleMatches(Entity entity, List<Entity> refMatches) {
        ArrayList alleleMatches = Lists.newArrayList();
        for (String alt : entity.getString(this.vcfAttributes.getAltAttribute().getName()).split(",")) {
            alleleMatches.add(refMatches.stream().filter(gonl -> alt.equals(gonl.getString(this.vcfAttributes.getAltAttribute().getName()))).findFirst().orElse(null));
        }
        return alleleMatches;
    }

    private boolean hasAltAttribute(Entity entity) {
        return entity.getString(this.vcfAttributes.getAltAttribute().getName()) != null;
    }

    private void shortenGoNLRef(Entity entity, Entity resourceEntity) {
        int postFixInputLength = resourceEntity.getString(this.vcfAttributes.getRefAttribute().getName()).substring(entity.getString(this.vcfAttributes.getRefAttribute().getName()).length()).length();
        resourceEntity.set(this.vcfAttributes.getRefAttribute().getName(), (Object)resourceEntity.getString(this.vcfAttributes.getRefAttribute().getName()).substring(0, resourceEntity.getString(this.vcfAttributes.getRefAttribute().getName()).length() - postFixInputLength));
        String newAltString = Arrays.stream(resourceEntity.getString(this.vcfAttributes.getAltAttribute().getName()).split(",")).map(alt -> alt.length() > postFixInputLength ? alt.substring(0, alt.length() - postFixInputLength) : "n/a").collect(Collectors.joining(","));
        resourceEntity.set(this.vcfAttributes.getAltAttribute().getName(), (Object)newAltString);
    }

    private boolean shouldShortenGoNLRef(Entity entity, Entity resourceEntity) {
        return resourceEntity.getString(this.vcfAttributes.getRefAttribute().getName()).indexOf(entity.getString(this.vcfAttributes.getRefAttribute().getName())) == 0;
    }

    private void lengthenGoNLRef(Entity entity, Entity resourceEntity) {
        String postFixResource = entity.getString(this.vcfAttributes.getRefAttribute().getName()).substring(resourceEntity.getString(this.vcfAttributes.getRefAttribute().getName()).length());
        resourceEntity.set(this.vcfAttributes.getRefAttribute().getName(), (Object)(resourceEntity.getString(this.vcfAttributes.getRefAttribute().getName()) + postFixResource));
        String newAltString = Arrays.stream(resourceEntity.getString(this.vcfAttributes.getAltAttribute().getName()).split(",")).map(alt -> alt + postFixResource).collect(Collectors.joining(","));
        resourceEntity.set(this.vcfAttributes.getAltAttribute().getName(), (Object)newAltString);
    }

    private boolean shouldLengthenGoNLRef(Entity resourceEntity) {
        return this.vcfAttributes.getRefAttribute().getName().indexOf(resourceEntity.getString(this.vcfAttributes.getRefAttribute().getName())) == 0;
    }

    private boolean refMatches(Entity resourceEntity) {
        return resourceEntity.get(this.vcfAttributes.getRefAttribute().getName()).equals(this.vcfAttributes.getRefAttribute().getName());
    }
}

