/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.annotation.core.entity.impl.framework;

import com.google.common.base.Optional;
import java.util.List;
import org.molgenis.data.DataService;
import org.molgenis.data.Entity;
import org.molgenis.data.annotation.core.entity.AnnotatorInfo;
import org.molgenis.data.annotation.core.entity.EntityAnnotator;
import org.molgenis.data.annotation.core.entity.QueryCreator;
import org.molgenis.data.annotation.core.entity.ResultFilter;
import org.molgenis.data.annotation.core.entity.impl.framework.QueryAnnotatorImpl;
import org.molgenis.data.annotation.core.resources.CmdLineAnnotatorSettingsConfigurer;
import org.molgenis.data.annotation.core.resources.Resources;
import org.molgenis.data.meta.model.Attribute;

public abstract class AbstractAnnotator
extends QueryAnnotatorImpl
implements EntityAnnotator {
    private final ResultFilter resultFilter;

    public AbstractAnnotator(String sourceRepositoryName, AnnotatorInfo info, QueryCreator queryCreator, ResultFilter resultFilter, DataService dataService, Resources resources, CmdLineAnnotatorSettingsConfigurer cmdLineAnnotatorSettingsConfigurer) {
        super(sourceRepositoryName, info, queryCreator, dataService, resources, cmdLineAnnotatorSettingsConfigurer);
        this.resultFilter = resultFilter;
    }

    @Override
    protected void processQueryResults(Entity entity, Iterable<Entity> annotationSourceEntities, boolean updateMode) {
        Optional<Entity> filteredResult = this.resultFilter.filterResults(annotationSourceEntities, entity, updateMode);
        if (filteredResult.isPresent()) {
            for (Attribute attr : this.getInfo().getOutputAttributes()) {
                entity.set(attr.getName(), this.getResourceAttributeValue(attr, (Entity)filteredResult.get()));
            }
        } else {
            for (Attribute attr : this.getInfo().getOutputAttributes()) {
                if (updateMode && entity.get(attr.getName()) != null) continue;
                entity.set(attr.getName(), null);
            }
        }
    }

    protected Object getResourceAttributeValue(Attribute attr, Entity entity) {
        return entity.get(attr.getName());
    }

    @Override
    public List<Attribute> getRequiredAttributes() {
        List<Attribute> sourceMetaData = super.getRequiredAttributes();
        sourceMetaData.addAll(this.resultFilter.getRequiredAttributes());
        return sourceMetaData;
    }
}

