/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.annotation.core.entity.impl.framework;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.molgenis.data.DataService;
import org.molgenis.data.Entity;
import org.molgenis.data.Query;
import org.molgenis.data.annotation.core.entity.AnnotatorInfo;
import org.molgenis.data.annotation.core.entity.EntityAnnotator;
import org.molgenis.data.annotation.core.entity.QueryCreator;
import org.molgenis.data.annotation.core.resources.CmdLineAnnotatorSettingsConfigurer;
import org.molgenis.data.annotation.core.resources.Resources;
import org.molgenis.data.meta.model.Attribute;

public abstract class QueryAnnotatorImpl
implements EntityAnnotator {
    private final QueryCreator queryCreator;
    private Resources resources;
    private final DataService dataService;
    private final String sourceRepositoryName;
    private final AnnotatorInfo info;
    private final CmdLineAnnotatorSettingsConfigurer cmdLineAnnotatorSettingsConfigurer;

    public QueryAnnotatorImpl(String sourceRepositoryName, AnnotatorInfo info, QueryCreator queryCreator, DataService dataService, Resources resources, CmdLineAnnotatorSettingsConfigurer cmdLineAnnotatorSettingsConfigurer) {
        this.sourceRepositoryName = sourceRepositoryName;
        this.dataService = dataService;
        this.resources = resources;
        this.queryCreator = Objects.requireNonNull(queryCreator);
        this.info = info;
        this.cmdLineAnnotatorSettingsConfigurer = cmdLineAnnotatorSettingsConfigurer;
    }

    @Override
    public AnnotatorInfo getInfo() {
        return this.info;
    }

    @Override
    public List<Attribute> getAnnotatorAttributes() {
        return this.getInfo().getOutputAttributes();
    }

    @Override
    public boolean sourceExists() {
        return this.resources.hasRepository(this.sourceRepositoryName) || this.dataService.hasRepository(this.sourceRepositoryName);
    }

    @Override
    public List<Attribute> getRequiredAttributes() {
        ArrayList<Attribute> sourceMetaData = new ArrayList<Attribute>();
        sourceMetaData.addAll(this.queryCreator.getRequiredAttributes());
        return sourceMetaData;
    }

    public List<Entity> annotateEntity(Entity entity, boolean updateMode) {
        Query<Entity> q = this.queryCreator.createQuery(entity);
        Iterable<Object> annotatationSourceEntities = this.resources.hasRepository(this.sourceRepositoryName) ? this.resources.findAll(this.sourceRepositoryName, q) : () -> this.dataService.findAll(this.sourceRepositoryName, q).iterator();
        this.processQueryResults(entity, annotatationSourceEntities, updateMode);
        return Collections.singletonList(entity);
    }

    @Override
    public CmdLineAnnotatorSettingsConfigurer getCmdLineAnnotatorSettingsConfigurer() {
        return this.cmdLineAnnotatorSettingsConfigurer;
    }

    protected abstract void processQueryResults(Entity var1, Iterable<Entity> var2, boolean var3);
}

