/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.annotation.core.entity.impl.framework;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import org.molgenis.data.Entity;
import org.molgenis.data.annotation.core.AbstractRepositoryEntityAnnotator;
import org.molgenis.data.annotation.core.entity.AnnotatorInfo;
import org.molgenis.data.annotation.core.entity.EntityAnnotator;
import org.molgenis.data.annotation.core.resources.CmdLineAnnotatorSettingsConfigurer;
import org.molgenis.data.meta.model.Attribute;
import org.molgenis.data.meta.model.AttributeFactory;

public class RepositoryAnnotatorImpl
extends AbstractRepositoryEntityAnnotator {
    private final String name;
    private EntityAnnotator entityAnnotator;

    public RepositoryAnnotatorImpl(String name) {
        this.name = name;
    }

    public void init(EntityAnnotator entityAnnotator) {
        this.entityAnnotator = entityAnnotator;
    }

    @Override
    public List<Attribute> getOutputAttributes() {
        return this.entityAnnotator.getAnnotatorAttributes();
    }

    @Override
    public List<Attribute> getRequiredAttributes() {
        return this.entityAnnotator.getRequiredAttributes();
    }

    @Override
    public String getSimpleName() {
        return this.entityAnnotator.getInfo().getCode();
    }

    @Override
    public boolean annotationDataExists() {
        return this.entityAnnotator.sourceExists();
    }

    @Override
    public List<Entity> annotateEntity(Entity entity, boolean updateMode) throws IOException, InterruptedException {
        return Lists.newArrayList(this.entityAnnotator.annotateEntity(entity, updateMode));
    }

    @Override
    public AnnotatorInfo getInfo() {
        return this.entityAnnotator.getInfo();
    }

    @Override
    public CmdLineAnnotatorSettingsConfigurer getCmdLineAnnotatorSettingsConfigurer() {
        return this.entityAnnotator.getCmdLineAnnotatorSettingsConfigurer();
    }

    @Override
    public List<Attribute> createAnnotatorAttributes(AttributeFactory attributeFactory) {
        return this.entityAnnotator.createAnnotatorAttributes(attributeFactory);
    }
}

