/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.annotation.core.entity.impl.gavin;

import org.molgenis.data.annotation.core.entity.impl.gavin.Category;
import org.molgenis.data.annotation.core.entity.impl.gavin.GavinThresholds;
import org.molgenis.data.annotation.core.entity.impl.gavin.Judgment;
import org.molgenis.data.annotation.core.entity.impl.snpeff.Impact;

public class GavinAlgorithm {
    public static final String NAME = "GavinAnnotator";
    public static final double GENOMEWIDE_MAF_THRESHOLD = 0.003456145;
    public static final int GENOMEWIDE_CADD_THRESHOLD = 15;
    public static final int EXTRA_SENSITIVITY_FACTOR = 5;

    public Judgment classifyVariant(Impact impact, Double caddScaled, Double exacMAF, String gene, GavinThresholds gavinThresholds) {
        if (gavinThresholds == null) {
            return this.genomewideClassifyVariant(impact, caddScaled, exacMAF, gene);
        }
        gavinThresholds = gavinThresholds.withExtraSensitivity(5);
        if (caddScaled != null) {
            switch (gavinThresholds.getCategory()) {
                case C1: 
                case C2: {
                    if (gavinThresholds.isAboveMeanPathogenicCADDScore(caddScaled)) {
                        return Judgment.create(Judgment.Classification.Pathogenic, Judgment.Method.calibrated, gene, "Variant CADD score of " + caddScaled + " is greater than " + gavinThresholds.getMeanPathogenicCADDScore() + " in a gene for which CADD scores are informative.");
                    }
                    if (!gavinThresholds.isBelowMeanPopulationCADDScore(caddScaled)) break;
                    return Judgment.create(Judgment.Classification.Benign, Judgment.Method.calibrated, gene, "Variant CADD score of " + caddScaled + " is less than " + gavinThresholds.getMeanPopulationCADDScore() + " in a gene for which CADD scores are informative.");
                }
                case C3: 
                case C4: 
                case C5: {
                    if (gavinThresholds.isAboveSpec95thPerCADDThreshold(caddScaled)) {
                        return Judgment.create(Judgment.Classification.Pathogenic, Judgment.Method.calibrated, gene, "Variant CADD score of " + caddScaled + " is greater than " + gavinThresholds.getSpec95thPerCADDThreshold() + " for this gene.");
                    }
                    if (!gavinThresholds.isBelowSens95PerCADDThreshold(caddScaled)) break;
                    return Judgment.create(Judgment.Classification.Benign, Judgment.Method.calibrated, gene, "Variant CADD score of " + caddScaled + " is less than " + gavinThresholds.getSens95thPerCADDThreshold() + " for this gene.");
                }
            }
        }
        if (gavinThresholds.isAbovePathoMAFThreshold(exacMAF)) {
            return Judgment.create(Judgment.Classification.Benign, Judgment.Method.calibrated, gene, "Variant MAF of " + exacMAF + " is greater than " + gavinThresholds.getPathoMAFThreshold() + ".");
        }
        String mafReason = "the variant MAF of " + exacMAF + " is less than a MAF of " + gavinThresholds.getPathoMAFThreshold() + ".";
        if (impact != null) {
            if (gavinThresholds.getCategory() == Category.I1 && impact == Impact.HIGH) {
                return Judgment.create(Judgment.Classification.Pathogenic, Judgment.Method.calibrated, gene, "Variant is of high impact, while there are no known high impact variants in the population. Also, " + mafReason);
            }
            if (gavinThresholds.getCategory() == Category.I2 && (impact == Impact.MODERATE || impact == Impact.HIGH)) {
                return Judgment.create(Judgment.Classification.Pathogenic, Judgment.Method.calibrated, gene, "Variant is of high/moderate impact, while there are no known high/moderate impact variants in the population. Also, " + mafReason);
            }
            if (gavinThresholds.getCategory() == Category.I3 && (impact == Impact.LOW || impact == Impact.MODERATE || impact == Impact.HIGH)) {
                return Judgment.create(Judgment.Classification.Pathogenic, Judgment.Method.calibrated, gene, "Variant is of high/moderate/low impact, while there are no known high/moderate/low impact variants in the population. Also, " + mafReason);
            }
            if (impact == Impact.MODIFIER) {
                return Judgment.create(Judgment.Classification.Benign, Judgment.Method.calibrated, gene, "Variant is of 'modifier' impact, and therefore unlikely to be pathogenic. However, " + mafReason);
            }
        }
        return this.genomewideClassifyVariant(impact, caddScaled, exacMAF, gene);
    }

    public Judgment genomewideClassifyVariant(Impact impact, Double caddScaled, Double exacMAF, String gene) {
        if ((exacMAF = Double.valueOf(exacMAF != null ? exacMAF : 0.0)) > 0.003456145) {
            return Judgment.create(Judgment.Classification.Benign, Judgment.Method.genomewide, gene, "Variant MAF of " + exacMAF + " is not rare enough to generally be considered pathogenic.");
        }
        if (impact == Impact.MODIFIER) {
            return Judgment.create(Judgment.Classification.Benign, Judgment.Method.genomewide, gene, "Variant is of 'modifier' impact, and therefore unlikely to be pathogenic.");
        }
        if (caddScaled != null) {
            if (caddScaled > 15.0) {
                return Judgment.create(Judgment.Classification.Pathogenic, Judgment.Method.genomewide, gene, "Variant MAF of " + exacMAF + " is rare enough to be potentially pathogenic and its CADD score of " + caddScaled + " is greater than a global threshold of " + 15 + ".");
            }
            return Judgment.create(Judgment.Classification.Benign, Judgment.Method.genomewide, gene, "Variant CADD score of " + caddScaled + " is less than a global threshold of " + 15 + ", although the variant MAF of " + exacMAF + " is rare enough to be potentially pathogenic.");
        }
        return Judgment.create(Judgment.Classification.VOUS, Judgment.Method.genomewide, gene, "Unable to classify variant as benign or pathogenic. The combination of " + (Object)((Object)impact) + " impact, an unknown CADD score and MAF of " + exacMAF + " in " + gene + " is inconclusive.");
    }
}

