/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.annotation.core.entity.impl.gavin;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.molgenis.data.DataService;
import org.molgenis.data.Entity;
import org.molgenis.data.MolgenisDataException;
import org.molgenis.data.annotation.core.EffectBasedAnnotator;
import org.molgenis.data.annotation.core.effects.EffectsMetaData;
import org.molgenis.data.annotation.core.entity.AnnotatorConfig;
import org.molgenis.data.annotation.core.entity.AnnotatorInfo;
import org.molgenis.data.annotation.core.entity.impl.CaddAnnotator;
import org.molgenis.data.annotation.core.entity.impl.ExacAnnotator;
import org.molgenis.data.annotation.core.entity.impl.framework.QueryAnnotatorImpl;
import org.molgenis.data.annotation.core.entity.impl.gavin.GavinAlgorithm;
import org.molgenis.data.annotation.core.entity.impl.gavin.GavinThresholds;
import org.molgenis.data.annotation.core.entity.impl.gavin.Judgment;
import org.molgenis.data.annotation.core.entity.impl.snpeff.Impact;
import org.molgenis.data.annotation.core.query.GeneNameQueryCreator;
import org.molgenis.data.annotation.core.resources.Resource;
import org.molgenis.data.annotation.core.resources.Resources;
import org.molgenis.data.annotation.core.resources.impl.RepositoryFactory;
import org.molgenis.data.annotation.core.resources.impl.SingleResourceConfig;
import org.molgenis.data.annotation.core.resources.impl.emx.EmxResourceImpl;
import org.molgenis.data.annotation.core.resources.impl.emx.InMemoryRepositoryFactory;
import org.molgenis.data.annotation.core.utils.AnnotatorUtils;
import org.molgenis.data.importer.MetaDataParser;
import org.molgenis.data.importer.emx.EmxMetaDataParser;
import org.molgenis.data.meta.AttributeType;
import org.molgenis.data.meta.EntityTypeDependencyResolver;
import org.molgenis.data.meta.model.Attribute;
import org.molgenis.data.meta.model.AttributeFactory;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.data.meta.model.EntityTypeFactory;
import org.molgenis.data.meta.model.PackageFactory;
import org.molgenis.data.vcf.model.VcfAttributes;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class GavinAnnotator
implements AnnotatorConfig {
    public static final String NAME = "Gavin";
    public static final String RESOURCE = "gavin";
    public static final String RESOURCE_ENTITY_NAME = "base_gavin";
    public static final String CLASSIFICATION = "Classification";
    public static final String CONFIDENCE = "Confidence";
    public static final String REASON = "Reason";
    private final GavinAlgorithm gavinAlgorithm = new GavinAlgorithm();
    @Autowired
    private Entity gavinAnnotatorSettings;
    @Autowired
    private DataService dataService;
    @Autowired
    private Resources resources;
    @Autowired
    private VcfAttributes vcfAttributes;
    @Autowired
    private PackageFactory packageFactory;
    @Autowired
    private EntityTypeFactory entityTypeFactory;
    @Autowired
    private AttributeFactory attributeFactory;
    @Autowired
    private EffectsMetaData effectsMetaData;
    @Autowired
    private EntityTypeDependencyResolver entityTypeDependencyResolver;
    @Autowired
    GeneNameQueryCreator geneNameQueryCreator;
    private EffectBasedAnnotator annotator;

    @Bean
    Resource GavinResource() {
        return new EmxResourceImpl(RESOURCE, new SingleResourceConfig("variantFileLocation", this.gavinAnnotatorSettings)){

            @Override
            public RepositoryFactory getRepositoryFactory() {
                return new InMemoryRepositoryFactory(GavinAnnotator.RESOURCE_ENTITY_NAME, GavinAnnotator.RESOURCE, (MetaDataParser)new EmxMetaDataParser(GavinAnnotator.this.packageFactory, GavinAnnotator.this.attributeFactory, GavinAnnotator.this.entityTypeFactory, GavinAnnotator.this.entityTypeDependencyResolver), GavinAnnotator.this.entityTypeFactory, GavinAnnotator.this.attributeFactory);
            }
        };
    }

    @Bean
    public EffectBasedAnnotator gavin() {
        this.annotator = new EffectBasedAnnotator(NAME);
        return this.annotator;
    }

    @Override
    public void init() {
        LinkedList<Attribute> attributes = this.createGavinOutputAttributes();
        String description = "Please note that this annotator processes the results from a SnpEff annotation\nTherefor it should be used on the result entity rather than the variant entity itself.\nThe corresponding variant entity should also be annotated with CADD and EXaC";
        AnnotatorInfo gavinInfo = AnnotatorInfo.create(AnnotatorInfo.Status.READY, AnnotatorInfo.Type.PATHOGENICITY_ESTIMATE, NAME, description, attributes);
        QueryAnnotatorImpl entityAnnotator = new QueryAnnotatorImpl(RESOURCE, gavinInfo, this.geneNameQueryCreator, this.dataService, this.resources, annotationSourceFileName -> this.gavinAnnotatorSettings.set("variantFileLocation", (Object)annotationSourceFileName)){

            @Override
            public List<Attribute> createAnnotatorAttributes(AttributeFactory attributeFactory) {
                return GavinAnnotator.this.createGavinOutputAttributes();
            }

            @Override
            public List<Attribute> getRequiredAttributes() {
                ArrayList<Attribute> requiredAttributes = new ArrayList<Attribute>();
                EntityType entityType = (EntityType)GavinAnnotator.this.entityTypeFactory.create((Object)"VARIANT");
                List<Attribute> refAttributesList = Arrays.asList(CaddAnnotator.createCaddScaledAttr(GavinAnnotator.this.attributeFactory), ExacAnnotator.getExacAFAttr(GavinAnnotator.this.attributeFactory), GavinAnnotator.this.vcfAttributes.getAltAttribute());
                entityType.addAttributes(refAttributesList);
                Attribute refAttr = GavinAnnotator.this.attributeFactory.create().setName("VARIANT").setDataType(AttributeType.XREF).setRefEntity(entityType).setDescription("This annotator needs a references to an entity containing: " + StreamSupport.stream(refAttributesList.spliterator(), false).map(Attribute::getName).collect(Collectors.joining(", ")));
                requiredAttributes.addAll(Arrays.asList(GavinAnnotator.this.effectsMetaData.getGeneNameAttr(), GavinAnnotator.this.effectsMetaData.getPutativeImpactAttr(), refAttr, GavinAnnotator.this.effectsMetaData.getAltAttr()));
                return requiredAttributes;
            }

            @Override
            protected void processQueryResults(Entity entity, Iterable<Entity> annotationSourceEntities, boolean updateMode) {
                if (updateMode) {
                    throw new MolgenisDataException("This annotator/filter does not support updating of values");
                }
                String alt = entity.getString("Alt_Allele");
                if (alt == null) {
                    entity.set(GavinAnnotator.CLASSIFICATION, (Object)"");
                    entity.set(GavinAnnotator.CONFIDENCE, (Object)"");
                    entity.set(GavinAnnotator.REASON, (Object)"Missing ALT allele no judgment could be determined.");
                    return;
                }
                if (alt.contains(",")) {
                    throw new MolgenisDataException("The gavin annotator only accepts single allele input ('effect entities').");
                }
                int sourceEntitiesSize = Iterables.size(annotationSourceEntities);
                Entity variantEntity = entity.getEntity("VARIANT");
                Map<String, Double> caddMap = AnnotatorUtils.toAlleleMap(variantEntity.getString("ALT"), variantEntity.getString("CADD_SCALED"));
                Map<String, Double> exacMap = AnnotatorUtils.toAlleleMap(variantEntity.getString("ALT"), variantEntity.getString("EXAC_AF"));
                Impact impact = Impact.valueOf(entity.getString("Putative_impact"));
                Double exacMAF = exacMap.get(alt);
                Double caddScaled = caddMap.get(alt);
                String gene = entity.getString("Gene_Name");
                if (exacMAF == null) {
                    exacMAF = 0.0;
                }
                if (sourceEntitiesSize == 1) {
                    Entity annotationSourceEntity = annotationSourceEntities.iterator().next();
                    Judgment judgment = GavinAnnotator.this.gavinAlgorithm.classifyVariant(impact, caddScaled, exacMAF, gene, GavinThresholds.fromEntity(annotationSourceEntity));
                    entity.set(GavinAnnotator.CLASSIFICATION, (Object)judgment.getClassification().toString());
                    entity.set(GavinAnnotator.CONFIDENCE, (Object)judgment.getConfidence().toString());
                    entity.set(GavinAnnotator.REASON, (Object)judgment.getReason());
                } else if (sourceEntitiesSize == 0) {
                    Judgment judgment = GavinAnnotator.this.gavinAlgorithm.genomewideClassifyVariant(impact, caddScaled, exacMAF, gene);
                    entity.set(GavinAnnotator.CLASSIFICATION, (Object)judgment.getClassification().toString());
                    entity.set(GavinAnnotator.CONFIDENCE, (Object)judgment.getConfidence().toString());
                    entity.set(GavinAnnotator.REASON, (Object)judgment.getReason());
                } else {
                    String message = "invalid number [" + sourceEntitiesSize + "] of results for this gene in annotation resource";
                    entity.set(GavinAnnotator.REASON, (Object)message);
                    throw new MolgenisDataException(message);
                }
            }
        };
        this.annotator.init(entityAnnotator);
    }

    private LinkedList<Attribute> createGavinOutputAttributes() {
        LinkedList<Attribute> attributes = new LinkedList<Attribute>();
        Attribute classification = this.attributeFactory.create().setName(CLASSIFICATION).setDataType(AttributeType.STRING).setDescription(CLASSIFICATION).setLabel(CLASSIFICATION);
        Attribute confidence = this.attributeFactory.create().setName(CONFIDENCE).setDataType(AttributeType.STRING).setDescription(CONFIDENCE).setLabel(CONFIDENCE);
        Attribute reason = this.attributeFactory.create().setName(REASON).setDataType(AttributeType.STRING).setDescription(REASON).setLabel(REASON);
        attributes.add(classification);
        attributes.add(confidence);
        attributes.add(reason);
        return attributes;
    }
}

