/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.annotation.core.entity.impl.hpo;

import java.util.ArrayList;
import java.util.List;
import org.molgenis.data.DataService;
import org.molgenis.data.Entity;
import org.molgenis.data.annotation.core.RepositoryAnnotator;
import org.molgenis.data.annotation.core.entity.AnnotatorConfig;
import org.molgenis.data.annotation.core.entity.AnnotatorInfo;
import org.molgenis.data.annotation.core.entity.impl.framework.AbstractAnnotator;
import org.molgenis.data.annotation.core.entity.impl.framework.RepositoryAnnotatorImpl;
import org.molgenis.data.annotation.core.entity.impl.hpo.HPORepository;
import org.molgenis.data.annotation.core.entity.impl.hpo.HpoResultFilter;
import org.molgenis.data.annotation.core.query.GeneNameQueryCreator;
import org.molgenis.data.annotation.core.resources.Resource;
import org.molgenis.data.annotation.core.resources.Resources;
import org.molgenis.data.annotation.core.resources.impl.RepositoryFactory;
import org.molgenis.data.annotation.core.resources.impl.ResourceImpl;
import org.molgenis.data.annotation.core.resources.impl.SingleResourceConfig;
import org.molgenis.data.annotation.web.settings.SingleFileLocationCmdLineAnnotatorSettingsConfigurer;
import org.molgenis.data.meta.AttributeType;
import org.molgenis.data.meta.model.Attribute;
import org.molgenis.data.meta.model.AttributeFactory;
import org.molgenis.data.meta.model.EntityTypeFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class HPOAnnotator
implements AnnotatorConfig {
    public static final String NAME = "hpo";
    public static final String HPO_IDS = "HPOIDS";
    public static final String HPO_TERMS = "HPOTERMS";
    private static final String HPO_RESOURCE = "HPOResource";
    @Autowired
    private Entity HPOAnnotatorSettings;
    @Autowired
    private DataService dataService;
    @Autowired
    private Resources resources;
    @Autowired
    private EntityTypeFactory entityTypeFactory;
    @Autowired
    GeneNameQueryCreator geneNameQueryCreator;
    @Autowired
    private AttributeFactory attributeFactory;
    private RepositoryAnnotatorImpl annotator;

    @Bean
    public RepositoryAnnotator hpo() {
        this.annotator = new RepositoryAnnotatorImpl(NAME);
        return this.annotator;
    }

    public Attribute getIdsAttr() {
        return this.attributeFactory.create().setName(HPO_IDS).setDataType(AttributeType.TEXT).setDescription("HPO identifiers");
    }

    public Attribute getTermsAttr() {
        return this.attributeFactory.create().setName(HPO_TERMS).setDataType(AttributeType.TEXT).setDescription("HPO terms");
    }

    @Override
    public void init() {
        List<Attribute> attributes = this.createHpoOutputAttributes();
        AnnotatorInfo info = AnnotatorInfo.create(AnnotatorInfo.Status.READY, AnnotatorInfo.Type.PHENOTYPE_ASSOCIATION, NAME, "The Human Phenotype Ontology (HPO) aims to provide a standardized vocabulary of phenotypic abnormalities encountered in human disease.Terms in the HPO describes a phenotypic abnormality, such as atrial septal defect.The HPO is currently being developed using the medical literature, Orphanet, DECIPHER, and OMIM. HPO currently contains approximately 11,000 terms and over 115,000 annotations to hereditary diseases.Please note that if SnpEff was used to annotate in order to add the gene symbols to the variants, than this annotator should be used on the result entity rather than the variant entity itself.", attributes);
        AbstractAnnotator entityAnnotator = new AbstractAnnotator(HPO_RESOURCE, info, this.geneNameQueryCreator, new HpoResultFilter(this.entityTypeFactory, this), this.dataService, this.resources, new SingleFileLocationCmdLineAnnotatorSettingsConfigurer("hpoLocation", this.HPOAnnotatorSettings)){

            @Override
            public List<Attribute> createAnnotatorAttributes(AttributeFactory attributeFactory) {
                return HPOAnnotator.this.createHpoOutputAttributes();
            }
        };
        this.annotator.init(entityAnnotator);
    }

    private List<Attribute> createHpoOutputAttributes() {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        attributes.add(this.getIdsAttr());
        attributes.add(this.getTermsAttr());
        return attributes;
    }

    @Bean
    public Resource hpoResource() {
        return new ResourceImpl(HPO_RESOURCE, new SingleResourceConfig("hpoLocation", this.HPOAnnotatorSettings)){

            @Override
            public RepositoryFactory getRepositoryFactory() {
                return file -> new HPORepository(file, HPOAnnotator.this.entityTypeFactory, HPOAnnotator.this.attributeFactory);
            }
        };
    }
}

