/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.annotation.core.entity.impl.hpo;

import au.com.bytecode.opencsv.CSVReader;
import com.google.common.collect.Iterables;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.molgenis.data.Entity;
import org.molgenis.data.MolgenisDataException;
import org.molgenis.data.Query;
import org.molgenis.data.QueryRule;
import org.molgenis.data.RepositoryCapability;
import org.molgenis.data.meta.model.AttributeFactory;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.data.meta.model.EntityTypeFactory;
import org.molgenis.data.support.AbstractRepository;
import org.molgenis.data.support.DynamicEntity;

public class HPORepository
extends AbstractRepository {
    public static final String HPO_DISEASE_ID_COL_NAME = "diseaseId";
    public static final String HPO_GENE_SYMBOL_COL_NAME = "gene-symbol";
    public static final String HPO_ID_COL_NAME = "HPO-ID";
    public static final String HPO_TERM_COL_NAME = "HPO-term-name";
    private final EntityTypeFactory entityTypeFactory;
    private final AttributeFactory attributeFactory;
    private Map<String, List<Entity>> entitiesByGeneSymbol;
    private final File file;

    public HPORepository(File file, EntityTypeFactory entityTypeFactory, AttributeFactory attributeFactory) {
        this.file = file;
        this.entityTypeFactory = entityTypeFactory;
        this.attributeFactory = attributeFactory;
    }

    public Set<RepositoryCapability> getCapabilities() {
        return Collections.emptySet();
    }

    public EntityType getEntityType() {
        EntityType entityType = (EntityType)this.entityTypeFactory.create((Object)"HPO");
        entityType.addAttribute(this.attributeFactory.create().setName(HPO_DISEASE_ID_COL_NAME), new EntityType.AttributeRole[0]);
        entityType.addAttribute(this.attributeFactory.create().setName(HPO_GENE_SYMBOL_COL_NAME), new EntityType.AttributeRole[0]);
        entityType.addAttribute(this.attributeFactory.create().setName(HPO_ID_COL_NAME), new EntityType.AttributeRole[]{EntityType.AttributeRole.ROLE_ID});
        entityType.addAttribute(this.attributeFactory.create().setName(HPO_TERM_COL_NAME), new EntityType.AttributeRole[0]);
        return entityType;
    }

    public Iterator<Entity> iterator() {
        return this.getEntities().iterator();
    }

    public Stream<Entity> findAll(Query<Entity> q) {
        if (q.getRules().isEmpty()) {
            return this.getEntities().stream();
        }
        if (q.getRules().size() != 1 || ((QueryRule)q.getRules().get(0)).getOperator() != QueryRule.Operator.EQUALS) {
            throw new MolgenisDataException("The only query allowed on this Repository is gene EQUALS");
        }
        String geneSymbol = (String)((QueryRule)q.getRules().get(0)).getValue();
        List<Entity> entities = this.getEntitiesByGeneSymbol().get(geneSymbol);
        return entities != null ? entities.stream() : Stream.empty();
    }

    public long count() {
        return Iterables.size((Iterable)((Object)this));
    }

    private List<Entity> getEntities() {
        ArrayList<Entity> entities = new ArrayList<Entity>();
        this.getEntitiesByGeneSymbol().forEach((geneSymbol, geneSymbolEntities) -> entities.addAll((Collection<Entity>)geneSymbolEntities));
        return entities;
    }

    private Map<String, List<Entity>> getEntitiesByGeneSymbol() {
        if (this.entitiesByGeneSymbol == null) {
            this.entitiesByGeneSymbol = new LinkedHashMap<String, List<Entity>>();
            try (CSVReader csvReader = new CSVReader((Reader)new InputStreamReader((InputStream)new FileInputStream(this.file), StandardCharsets.UTF_8), '\t', '\"', 1);){
                String[] values = csvReader.readNext();
                while (values != null) {
                    String geneSymbol = values[1];
                    DynamicEntity entity = new DynamicEntity(this.getEntityType());
                    entity.set(HPO_DISEASE_ID_COL_NAME, (Object)values[0]);
                    entity.set(HPO_GENE_SYMBOL_COL_NAME, (Object)geneSymbol);
                    entity.set(HPO_ID_COL_NAME, (Object)values[3]);
                    entity.set(HPO_TERM_COL_NAME, (Object)values[4]);
                    List entities = this.entitiesByGeneSymbol.computeIfAbsent(geneSymbol, k -> new ArrayList());
                    entities.add(entity);
                    values = csvReader.readNext();
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return this.entitiesByGeneSymbol;
    }
}

