/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.annotation.core.entity.impl.hpo;

import com.google.common.base.Optional;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.molgenis.data.Entity;
import org.molgenis.data.MolgenisDataException;
import org.molgenis.data.annotation.core.entity.ResultFilter;
import org.molgenis.data.annotation.core.entity.impl.hpo.HPOAnnotator;
import org.molgenis.data.meta.model.Attribute;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.data.meta.model.EntityTypeFactory;
import org.molgenis.data.support.DynamicEntity;

public class HpoResultFilter
implements ResultFilter {
    private EntityTypeFactory entityTypeFactory;
    private HPOAnnotator hpoAnnotator;

    public HpoResultFilter(EntityTypeFactory entityTypeFactory, HPOAnnotator hpoAnnotator) {
        this.entityTypeFactory = entityTypeFactory;
        this.hpoAnnotator = hpoAnnotator;
    }

    @Override
    public Collection<Attribute> getRequiredAttributes() {
        return Collections.emptyList();
    }

    @Override
    public Optional<Entity> filterResults(Iterable<Entity> results, Entity annotatedEntity, boolean updateMode) {
        if (updateMode) {
            throw new MolgenisDataException("This annotator/filter does not support updating of values");
        }
        StringBuilder ids = new StringBuilder();
        StringBuilder terms = new StringBuilder();
        for (Entity hpoEntity : results) {
            if (ids.length() > 0) {
                ids.append('/');
                terms.append('/');
            }
            String hpoId = hpoEntity.getString("HPO-ID");
            String hpoTerm = hpoEntity.getString("HPO-term-name");
            ids.append(hpoId);
            terms.append(hpoTerm);
        }
        EntityType emd = (EntityType)this.entityTypeFactory.create((Object)"hpo");
        emd.addAttributes(Arrays.asList(this.hpoAnnotator.getIdsAttr(), this.hpoAnnotator.getTermsAttr()));
        DynamicEntity aggregated = new DynamicEntity(emd);
        aggregated.set("HPOIDS", (Object)ids.toString());
        aggregated.set("HPOTERMS", (Object)terms.toString());
        return ids.length() == 0 ? Optional.absent() : Optional.of((Object)aggregated);
    }
}

