/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.annotation.core.entity.impl.omim;

import au.com.bytecode.opencsv.CSVReader;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.molgenis.data.Entity;
import org.molgenis.data.MolgenisDataException;
import org.molgenis.data.Query;
import org.molgenis.data.QueryRule;
import org.molgenis.data.RepositoryCapability;
import org.molgenis.data.meta.model.AttributeFactory;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.data.meta.model.EntityTypeFactory;
import org.molgenis.data.support.AbstractRepository;
import org.molgenis.data.support.DynamicEntity;

public class OmimRepository
extends AbstractRepository {
    public static final String OMIM_AUTO_ID_COL_NAME = "ID";
    public static final String OMIM_PHENOTYPE_COL_NAME = "Phenotype";
    public static final String OMIM_GENE_SYMBOLS_COL_NAME = "Gene_Name";
    public static final String OMIM_MIM_NUMBER_COL_NAME = "MIMNumber";
    public static final String OMIM_CYTO_LOCATION_COL_NAME = "CytoLocation";
    public static final String OMIM_ENTRY_COL_NAME = "OmimEntry";
    public static final String OMIM_TYPE_COL_NAME = "OmimType";
    private final AttributeFactory attributeFactory;
    private final EntityTypeFactory entityTypeFactory;
    private Map<String, List<Entity>> entitiesByGeneSymbol;
    private final File file;

    public OmimRepository(File file, EntityTypeFactory entityTypeFactory, AttributeFactory attributeFactory) {
        this.file = file;
        this.entityTypeFactory = entityTypeFactory;
        this.attributeFactory = attributeFactory;
    }

    public Set<RepositoryCapability> getCapabilities() {
        return Collections.emptySet();
    }

    public EntityType getEntityType() {
        EntityType entityType = (EntityType)this.entityTypeFactory.create((Object)"OMIM");
        entityType.addAttribute(this.attributeFactory.create().setName(OMIM_GENE_SYMBOLS_COL_NAME), new EntityType.AttributeRole[]{EntityType.AttributeRole.ROLE_ID});
        entityType.addAttribute(this.attributeFactory.create().setName(OMIM_PHENOTYPE_COL_NAME), new EntityType.AttributeRole[0]);
        entityType.addAttribute(this.attributeFactory.create().setName(OMIM_MIM_NUMBER_COL_NAME), new EntityType.AttributeRole[0]);
        entityType.addAttribute(this.attributeFactory.create().setName(OMIM_CYTO_LOCATION_COL_NAME), new EntityType.AttributeRole[0]);
        entityType.addAttribute(this.attributeFactory.create().setName(OMIM_ENTRY_COL_NAME), new EntityType.AttributeRole[0]);
        entityType.addAttribute(this.attributeFactory.create().setName(OMIM_TYPE_COL_NAME), new EntityType.AttributeRole[0]);
        return entityType;
    }

    public Iterator<Entity> iterator() {
        return this.getEntities().iterator();
    }

    public Stream<Entity> findAll(Query<Entity> q) {
        if (q.getRules().isEmpty()) {
            return this.getEntities().stream();
        }
        if (q.getRules().size() != 1 || ((QueryRule)q.getRules().get(0)).getOperator() != QueryRule.Operator.EQUALS) {
            throw new MolgenisDataException("The only query allowed on this Repository is gene EQUALS");
        }
        String geneSymbol = (String)((QueryRule)q.getRules().get(0)).getValue();
        List<Entity> entities = this.getEntitiesByGeneSymbol().get(geneSymbol);
        return entities != null ? entities.stream() : Stream.empty();
    }

    public long count() {
        return Iterables.size((Iterable)((Object)this));
    }

    private List<Entity> getEntities() {
        ArrayList<Entity> entities = new ArrayList<Entity>();
        this.getEntitiesByGeneSymbol().forEach((geneSymbol, geneSymbolEntities) -> entities.addAll((Collection<Entity>)geneSymbolEntities));
        return entities;
    }

    private Map<String, List<Entity>> getEntitiesByGeneSymbol() {
        if (this.entitiesByGeneSymbol == null) {
            HashMap<String, List<List<String>>> omimEntriesByGeneSymbol = new HashMap<String, List<List<String>>>();
            this.entitiesByGeneSymbol = new LinkedHashMap<String, List<Entity>>();
            try (CSVReader csvReader = new CSVReader((Reader)new InputStreamReader((InputStream)new FileInputStream(this.file), Charset.forName("UTF-8")), '\t', '\"', 1);){
                String[] values = csvReader.readNext();
                while (values != null) {
                    this.addLineToMap(omimEntriesByGeneSymbol, values);
                    values = csvReader.readNext();
                }
                for (String geneSymbol : omimEntriesByGeneSymbol.keySet()) {
                    this.addEntityToGeneEntityList(omimEntriesByGeneSymbol, geneSymbol);
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return this.entitiesByGeneSymbol;
    }

    private void addEntityToGeneEntityList(Map<String, List<List<String>>> omimEntriesByGeneSymbol, String geneSymbol) {
        DynamicEntity entity = new DynamicEntity(this.getEntityType());
        entity.set(OMIM_GENE_SYMBOLS_COL_NAME, (Object)geneSymbol);
        entity.set(OMIM_PHENOTYPE_COL_NAME, (Object)StringUtils.join((Iterable)omimEntriesByGeneSymbol.get(geneSymbol).get(0), (String)","));
        entity.set(OMIM_MIM_NUMBER_COL_NAME, (Object)StringUtils.join((Iterable)omimEntriesByGeneSymbol.get(geneSymbol).get(1), (String)","));
        entity.set(OMIM_CYTO_LOCATION_COL_NAME, (Object)StringUtils.join((Iterable)omimEntriesByGeneSymbol.get(geneSymbol).get(2), (String)","));
        entity.set(OMIM_TYPE_COL_NAME, (Object)StringUtils.join((Iterable)omimEntriesByGeneSymbol.get(geneSymbol).get(3), (String)","));
        entity.set(OMIM_ENTRY_COL_NAME, (Object)StringUtils.join((Iterable)omimEntriesByGeneSymbol.get(geneSymbol).get(4), (String)","));
        List entities = this.entitiesByGeneSymbol.computeIfAbsent(geneSymbol, k -> new ArrayList());
        entities.add(entity);
    }

    private void addLineToMap(Map<String, List<List<String>>> omimEntriesByGeneSymbol, String[] values) {
        String entry = values[0];
        entry = entry.substring(0, entry.length() - 3);
        entry = entry.trim();
        if ((entry = entry.substring(entry.length() - 6)).matches("[0-9]+")) {
            String disorder = values[0].substring(0, values[0].length() - 12);
            List<String> genes = Arrays.asList(values[1].split(", "));
            String causalIdentifier = values[2];
            String cytogenicLocation = values[3];
            String type = values[0].substring(values[0].length() - 2, values[0].length() - 1);
            String omimEntry = entry;
            for (String geneSymbol : genes) {
                if (omimEntriesByGeneSymbol.containsKey(geneSymbol)) {
                    omimEntriesByGeneSymbol.get(geneSymbol).get(0).add(disorder);
                    omimEntriesByGeneSymbol.get(geneSymbol).get(1).add(causalIdentifier);
                    omimEntriesByGeneSymbol.get(geneSymbol).get(2).add(cytogenicLocation);
                    omimEntriesByGeneSymbol.get(geneSymbol).get(3).add(type);
                    omimEntriesByGeneSymbol.get(geneSymbol).get(4).add(omimEntry);
                    continue;
                }
                LinkedList<ArrayList> mapList = new LinkedList<ArrayList>();
                mapList.add(Lists.newArrayList((Object[])new String[]{disorder}));
                mapList.add(Lists.newArrayList((Object[])new String[]{causalIdentifier}));
                mapList.add(Lists.newArrayList((Object[])new String[]{cytogenicLocation}));
                mapList.add(Lists.newArrayList((Object[])new String[]{type}));
                mapList.add(Lists.newArrayList((Object[])new String[]{omimEntry}));
                omimEntriesByGeneSymbol.put(geneSymbol, mapList);
            }
        }
    }
}

