/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.annotation.core.entity.impl.omim;

import com.google.common.base.Optional;
import com.google.common.collect.FluentIterable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.molgenis.data.Entity;
import org.molgenis.data.MolgenisDataException;
import org.molgenis.data.annotation.core.entity.ResultFilter;
import org.molgenis.data.annotation.core.entity.impl.omim.OmimAnnotator;
import org.molgenis.data.meta.model.Attribute;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.data.meta.model.EntityTypeFactory;
import org.molgenis.data.support.DynamicEntity;

public class OmimResultFilter
implements ResultFilter {
    private EntityTypeFactory entityTypeFactory;
    private OmimAnnotator omimAnnotator;

    public OmimResultFilter(EntityTypeFactory entityTypeFactory, OmimAnnotator omimAnnotator) {
        this.entityTypeFactory = entityTypeFactory;
        this.omimAnnotator = omimAnnotator;
    }

    @Override
    public Collection<Attribute> getRequiredAttributes() {
        return Collections.emptyList();
    }

    @Override
    public Optional<Entity> filterResults(Iterable<Entity> results, Entity annotatedEntity, boolean updateMode) {
        if (updateMode) {
            throw new MolgenisDataException("This annotator/filter does not support updating of values");
        }
        Optional firstResult = FluentIterable.from(results).first();
        EntityType emd = ((EntityType)this.entityTypeFactory.create()).setId("OMIM");
        emd.addAttributes(Arrays.asList(this.omimAnnotator.getPhenotypeAttr(), this.omimAnnotator.getMimNumberAttr(), this.omimAnnotator.getOmimLocationAttr(), this.omimAnnotator.getEntryAttr(), this.omimAnnotator.getTypeAttr()));
        return firstResult.transform(e -> {
            DynamicEntity result = new DynamicEntity(emd);
            result.set("OMIM_Disorders", e.get("Phenotype"));
            result.set("OMIM_MIM_Numbers", e.get("MIMNumber"));
            result.set("OMIM_Cyto_Locations", e.get("CytoLocation"));
            result.set("OMIM_Type", (Object)e.get("OmimType").toString());
            result.set("OMIM_Entry", (Object)e.get("OmimEntry").toString());
            return result;
        });
    }
}

