/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.annotation.core.entity.impl.snpeff;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.PeekingIterator;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import org.molgenis.data.Entity;
import org.molgenis.data.MolgenisDataException;
import org.molgenis.data.annotation.core.effects.EffectsMetaData;
import org.molgenis.data.annotation.core.entity.impl.snpeff.SnpEffAnnotator;
import org.molgenis.data.annotation.core.utils.JarRunner;
import org.molgenis.data.meta.AttributeType;
import org.molgenis.data.meta.model.Attribute;
import org.molgenis.data.meta.model.AttributeFactory;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.data.meta.model.EntityTypeFactory;
import org.molgenis.data.populate.IdGenerator;
import org.molgenis.data.support.DynamicEntity;
import org.molgenis.data.vcf.VcfRepository;
import org.molgenis.data.vcf.model.VcfAttributes;
import org.molgenis.security.core.runas.RunAsSystemAspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SnpEffRunner {
    private final EntityTypeFactory entityTypeFactory;
    private final AttributeFactory attributeFactory;
    private final VcfAttributes vcfAttributes;
    private static final Logger LOG = LoggerFactory.getLogger(SnpEffAnnotator.class);
    private String snpEffPath;
    private static final String CHARSET = "UTF-8";
    public static final String ENTITY_NAME_SUFFIX = "EFFECTS";
    public static final String NAME = "snpEff";
    public static final String ANN = "ANN";
    private EffectsMetaData effectsMetaData = new EffectsMetaData();
    private final JarRunner jarRunner;
    private final Entity snpEffAnnotatorSettings;
    private final IdGenerator idGenerator;

    public SnpEffRunner(JarRunner jarRunner, Entity snpEffAnnotatorSettings, IdGenerator idGenerator, VcfAttributes vcfAttributes, EffectsMetaData effectsMetaData, EntityTypeFactory entityTypeFactory, AttributeFactory attributeFactory) {
        this.jarRunner = jarRunner;
        this.snpEffAnnotatorSettings = snpEffAnnotatorSettings;
        this.idGenerator = idGenerator;
        this.vcfAttributes = vcfAttributes;
        this.effectsMetaData = effectsMetaData;
        this.entityTypeFactory = entityTypeFactory;
        this.attributeFactory = attributeFactory;
    }

    public Iterator<Entity> getSnpEffects(Iterable<Entity> source) {
        try {
            File inputVcf = this.getInputVcfFile(source.iterator());
            return this.getSnpEffects(source.iterator(), inputVcf);
        }
        catch (IOException e) {
            throw new MolgenisDataException("Exception making temporary VCF file", (Throwable)e);
        }
    }

    public Iterator<Entity> getSnpEffects(Iterator<Entity> source, File inputVcf) {
        try {
            if (!source.hasNext()) {
                return Collections.emptyList().iterator();
            }
            final PeekingIterator peekingSourceIterator = Iterators.peekingIterator(source);
            final EntityType sourceEMD = ((Entity)peekingSourceIterator.peek()).getEntityType();
            List<String> params = Arrays.asList("-Xmx2g", this.getSnpEffPath(), "hg19", "-noStats", "-noLog", "-lof", "-canon", "-ud", "0", "-spliceSiteSize", "5");
            File outputVcf = this.jarRunner.runJar(NAME, params, inputVcf);
            VcfRepository repo = new VcfRepository(outputVcf, "SNPEFF_OUTPUT_VCF_" + inputVcf.getName(), this.vcfAttributes, this.entityTypeFactory, this.attributeFactory);
            final PeekingIterator snpEffResultIterator = Iterators.peekingIterator((Iterator)repo.iterator());
            return new Iterator<Entity>(){
                final LinkedList<Entity> effects = Lists.newLinkedList();

                @Override
                public boolean hasNext() {
                    return peekingSourceIterator.hasNext() || !this.effects.isEmpty();
                }

                @Override
                public Entity next() {
                    if (this.effects.isEmpty()) {
                        Entity sourceEntity = (Entity)peekingSourceIterator.next();
                        String chromosome = sourceEntity.getString("#CHROM");
                        Integer position = sourceEntity.getInt("POS");
                        if (chromosome != null && position != null) {
                            Entity snpEffEntity = SnpEffRunner.this.getSnpEffEntity((PeekingIterator<Entity>)snpEffResultIterator, chromosome, position);
                            if (snpEffEntity != null) {
                                this.effects.addAll(SnpEffRunner.this.getSnpEffectsFromSnpEffEntity(sourceEntity, snpEffEntity, SnpEffRunner.this.getTargetEntityType(sourceEMD)));
                            } else {
                                this.effects.add(SnpEffRunner.this.getEmptyEffectsEntity(sourceEntity, SnpEffRunner.this.getTargetEntityType(sourceEMD)));
                            }
                        } else {
                            this.effects.add(SnpEffRunner.this.getEmptyEffectsEntity(sourceEntity, SnpEffRunner.this.getTargetEntityType(sourceEMD)));
                        }
                    }
                    return this.effects.removeFirst();
                }
            };
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (InterruptedException e) {
            throw new MolgenisDataException("Exception running SnpEff", (Throwable)e);
        }
    }

    private Entity getSnpEffEntity(PeekingIterator<Entity> snpEffResultIterator, String chromosome, int position) {
        Entity entityCandidate;
        if (snpEffResultIterator.hasNext() && chromosome.equals((entityCandidate = (Entity)snpEffResultIterator.peek()).getString("#CHROM")) && position == entityCandidate.getInt("POS") && entityCandidate.getString(ANN) != null) {
            snpEffResultIterator.next();
            return entityCandidate;
        }
        return null;
    }

    private Entity getEmptyEffectsEntity(Entity sourceEntity, EntityType effectsEMD) {
        DynamicEntity effect = new DynamicEntity(effectsEMD);
        effect.set("id", (Object)this.idGenerator.generateId());
        effect.set("VARIANT", (Object)sourceEntity);
        return effect;
    }

    private List<Entity> getSnpEffectsFromSnpEffEntity(Entity sourceEntity, Entity snpEffEntity, EntityType effectsEMD) {
        String[] annotations = snpEffEntity.getString(ANN).split(Pattern.quote(","), -1);
        ArrayList effects = Lists.newArrayList();
        for (String annotation : annotations) {
            String[] fields = annotation.split(Pattern.quote("|"), -1);
            DynamicEntity effect = new DynamicEntity(effectsEMD);
            if (fields.length >= 15) {
                effect.set("id", (Object)this.idGenerator.generateId());
                effect.set("VARIANT", (Object)sourceEntity);
                effect.set("Alt_Allele", (Object)fields[0]);
                effect.set("Gene_Name", (Object)fields[4]);
                effect.set("Annotation", (Object)fields[1]);
                effect.set("Putative_impact", (Object)fields[2]);
                effect.set("Gene_Name", (Object)fields[3]);
                effect.set("Gene_ID", (Object)fields[4]);
                effect.set("Feature_type", (Object)fields[5]);
                effect.set("Feature_ID", (Object)fields[6]);
                effect.set("Transcript_biotype", (Object)fields[7]);
                effect.set("Rank_total", (Object)fields[8]);
                effect.set("HGVS_c", (Object)fields[9]);
                effect.set("HGVS_p", (Object)fields[10]);
                effect.set("cDNA_position", (Object)fields[11]);
                effect.set("CDS_position", (Object)fields[12]);
                effect.set("Protein_position", (Object)fields[13]);
                effect.set("Distance_to_feature", (Object)fields[14]);
                effect.set("Errors", (Object)fields[15]);
            } else {
                LOG.info("No results for CHROM:{} POS:{} REF:{} ALT:{} ", new Object[]{effect.getString("#CHROM"), effect.getString("POS"), effect.getString("REF"), effect.getString("ALT")});
            }
            effects.add(effect);
        }
        return effects;
    }

    public File getInputVcfFile(Iterator<Entity> source) throws IOException {
        File vcf = File.createTempFile(NAME, ".vcf");
        try (BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(vcf), CHARSET));){
            bw.write("#CHROM\tPOS\tID\tREF\tALT\tQUAL\tFILTER\tINFO\n");
            while (source.hasNext()) {
                Entity entity = source.next();
                StringBuilder builder = new StringBuilder();
                builder.append(entity.getString("#CHROM"));
                builder.append("\t");
                builder.append(entity.getInt("POS"));
                builder.append("\t.\t");
                builder.append(entity.getString("REF"));
                builder.append("\t");
                builder.append(entity.getString("ALT"));
                builder.append("\t.\t");
                builder.append("\t.\t");
                builder.append(".");
                if (source.hasNext()) {
                    builder.append("\n");
                }
                bw.write(builder.toString());
            }
        }
        return vcf;
    }

    public String getSnpEffPath() {
        if (this.snpEffAnnotatorSettings != null) {
            this.snpEffPath = (String)RunAsSystemAspect.runAsSystem(() -> this.snpEffAnnotatorSettings.getString("snpEffJarLocation"));
            if (this.snpEffPath != null) {
                File snpEffFile = new File(this.snpEffPath);
                if (snpEffFile.exists() && snpEffFile.isFile()) {
                    LOG.info("SnpEff found at: " + snpEffFile.getAbsolutePath());
                } else {
                    LOG.debug("SnpEff not found at: " + snpEffFile.getAbsolutePath());
                    this.snpEffPath = null;
                }
            }
        }
        return this.snpEffPath;
    }

    public EntityType getTargetEntityType(EntityType sourceEntityType) {
        EntityType entityType = ((EntityType)this.entityTypeFactory.create()).setId(sourceEntityType.getId() + ENTITY_NAME_SUFFIX).setLabel(sourceEntityType.getId() + "_" + ENTITY_NAME_SUFFIX).setPackage(sourceEntityType.getPackage());
        entityType.setBackend(sourceEntityType.getBackend());
        Attribute id = this.attributeFactory.create().setName("id").setAuto(true).setVisible(false).setIdAttribute(Boolean.valueOf(true));
        entityType.addAttribute(id, new EntityType.AttributeRole[0]);
        for (Attribute attr : this.effectsMetaData.getOrderedAttributes()) {
            entityType.addAttribute(attr, new EntityType.AttributeRole[0]);
        }
        entityType.addAttribute(this.attributeFactory.create().setName("VARIANT").setNillable(false).setDataType(AttributeType.XREF).setRefEntity(sourceEntityType), new EntityType.AttributeRole[0]);
        return entityType;
    }
}

