/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.annotation.core.filter;

import com.google.common.base.Optional;
import com.google.common.collect.FluentIterable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Objects;
import org.molgenis.data.Entity;
import org.molgenis.data.MolgenisDataException;
import org.molgenis.data.annotation.core.entity.ResultFilter;
import org.molgenis.data.meta.model.Attribute;
import org.molgenis.data.vcf.model.VcfAttributes;

public class ClinvarMultiAllelicResultFilter
implements ResultFilter {
    private final VcfAttributes vcfAttributes;

    public ClinvarMultiAllelicResultFilter(VcfAttributes vcfAttributes) {
        this.vcfAttributes = Objects.requireNonNull(vcfAttributes);
    }

    @Override
    public Collection<Attribute> getRequiredAttributes() {
        return Arrays.asList(this.vcfAttributes.getRefAttribute(), this.vcfAttributes.getAltAttribute());
    }

    @Override
    public Optional<Entity> filterResults(Iterable<Entity> results, Entity annotatedEntity, boolean updateMode) {
        if (updateMode) {
            throw new MolgenisDataException("This annotator/filter does not support updating of values");
        }
        LinkedHashMap<String, String> clnallValueMap = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> clnsigValueMap = new LinkedHashMap<String, String>();
        ArrayList<Entity> processedResults = new ArrayList<Entity>();
        for (Entity entity : results) {
            int i;
            if (!entity.get("REF").equals(annotatedEntity.get("REF"))) continue;
            String[] alts = entity.getString("ALT").split(",");
            String[] clnSigs = entity.getString("CLNSIG").split(",");
            String[] clnAll = entity.getString("CLNALLE").split(",");
            StringBuilder newClnlallAttributeValue = new StringBuilder();
            StringBuilder newClnlsigAttributeValue = new StringBuilder();
            String[] annotatedEntityAltAlleles = annotatedEntity.getString("ALT").split(",");
            for (i = 0; i < clnSigs.length; ++i) {
                int significantAlleleIndex = Integer.parseInt(clnAll[i]);
                if (significantAlleleIndex == -1) continue;
                if (significantAlleleIndex == 0) {
                    String resultRefAllele = entity.getString("REF");
                    String refAllele = annotatedEntity.getString("REF");
                    if (!refAllele.equals(resultRefAllele)) continue;
                    clnallValueMap.put(refAllele, "0");
                    clnsigValueMap.put(refAllele, clnSigs[i]);
                    continue;
                }
                --significantAlleleIndex;
                for (int j = 0; j < annotatedEntityAltAlleles.length; ++j) {
                    if (!annotatedEntityAltAlleles[j].equals(alts[significantAlleleIndex])) continue;
                    String newSignificantAlleleIndex = Integer.toString(j + 1);
                    clnallValueMap.put(alts[significantAlleleIndex], newSignificantAlleleIndex);
                    clnsigValueMap.put(alts[significantAlleleIndex], clnSigs[i]);
                }
            }
            for (i = 0; i < annotatedEntityAltAlleles.length; ++i) {
                if (i != 0) {
                    newClnlallAttributeValue.append(",");
                    newClnlsigAttributeValue.append(",");
                }
                if (clnallValueMap.get(annotatedEntityAltAlleles[i]) != null) {
                    newClnlallAttributeValue.append((String)clnallValueMap.get(annotatedEntityAltAlleles[i]));
                } else {
                    newClnlallAttributeValue.append(".");
                }
                if (clnsigValueMap.get(annotatedEntityAltAlleles[i]) != null) {
                    newClnlsigAttributeValue.append((String)clnsigValueMap.get(annotatedEntityAltAlleles[i]));
                    continue;
                }
                newClnlsigAttributeValue.append(".");
            }
            if (newClnlallAttributeValue.toString().equals(".")) {
                entity.set("CLNSIG", (Object)"");
                entity.set("CLNALLE", (Object)"");
            } else {
                entity.set("CLNALLE", (Object)newClnlallAttributeValue.toString());
                entity.set("CLNSIG", (Object)newClnlsigAttributeValue.toString());
            }
            processedResults.add(entity);
        }
        return FluentIterable.from(processedResults).first();
    }
}

