/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.annotation.core.filter;

import com.google.common.base.Optional;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterators;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.PeekingIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.molgenis.data.Entity;
import org.molgenis.data.MolgenisDataException;
import org.molgenis.data.annotation.core.datastructures.Location;
import org.molgenis.data.annotation.core.entity.ResultFilter;
import org.molgenis.data.meta.model.Attribute;
import org.molgenis.data.support.EntityTypeUtils;
import org.molgenis.data.vcf.model.VcfAttributes;

public class MultiAllelicResultFilter
implements ResultFilter {
    private final List<Attribute> attributes;
    private final boolean mergeMultilineResourceResults;
    private final VcfAttributes vcfAttributes;

    public MultiAllelicResultFilter(List<Attribute> alleleSpecificAttributes, boolean mergeMultilineResourceResults, VcfAttributes vcfAttributes) {
        this.attributes = alleleSpecificAttributes;
        this.mergeMultilineResourceResults = mergeMultilineResourceResults;
        this.vcfAttributes = vcfAttributes;
    }

    public MultiAllelicResultFilter(List<Attribute> alleleSpecificAttributes, VcfAttributes vcfAttributes) {
        this.attributes = alleleSpecificAttributes;
        this.mergeMultilineResourceResults = false;
        this.vcfAttributes = vcfAttributes;
    }

    @Override
    public Collection<Attribute> getRequiredAttributes() {
        return Arrays.asList(this.vcfAttributes.getRefAttribute(), this.vcfAttributes.getAltAttribute());
    }

    @Override
    public Optional<Entity> filterResults(Iterable<Entity> resourceEntities, Entity sourceEntity, boolean updateMode) {
        ArrayList<Entity> processedResults = new ArrayList<Entity>();
        String sourceRef = sourceEntity.getString("REF");
        if (sourceRef == null) {
            return Optional.absent();
        }
        if (this.mergeMultilineResourceResults) {
            resourceEntities = this.merge(resourceEntities);
        }
        for (Entity resourceEntity : resourceEntities) {
            String postFix;
            String resourceRef = resourceEntity.getString("REF");
            if (resourceRef.equals(sourceRef)) {
                processedResults.addAll(this.filter(sourceEntity, resourceEntity, "", "", updateMode));
                continue;
            }
            if (resourceRef.startsWith(sourceRef)) {
                postFix = resourceRef.substring(sourceRef.length());
                processedResults.addAll(this.filter(sourceEntity, resourceEntity, postFix, "", updateMode));
                continue;
            }
            if (!sourceRef.startsWith(resourceRef)) continue;
            postFix = sourceRef.substring(resourceRef.length());
            processedResults.addAll(this.filter(sourceEntity, resourceEntity, "", postFix, updateMode));
        }
        return FluentIterable.from(processedResults).first();
    }

    private List<Entity> filter(Entity sourceEntity, Entity resourceEntity, String sourcePostfix, String resourcePostfix, boolean updateMode) {
        ArrayList result = Lists.newArrayList();
        HashMap<String, String> alleleValueMap = new HashMap<String, String>();
        HashMap<String, String> sourceAlleleValueMap = new HashMap<String, String>();
        String[] alts = resourceEntity.getString("ALT").split(",");
        String[] sourceAlts = sourceEntity.getString("ALT").split(",");
        for (Attribute attribute : this.attributes) {
            int i;
            String[] values = resourceEntity.getString(attribute.getName()).split(",", -1);
            for (int i2 = 0; i2 < alts.length; ++i2) {
                alleleValueMap.put(alts[i2] + resourcePostfix, values[i2]);
            }
            if (updateMode && sourceEntity.get(attribute.getName()) != null) {
                Attribute sourceAttr = sourceEntity.getEntityType().getAttribute(attribute.getName());
                if (EntityTypeUtils.isTextType((Attribute)sourceAttr) || EntityTypeUtils.isStringType((Attribute)sourceAttr)) {
                    String[] sourceValues = sourceEntity.getString(attribute.getName()).split(",", -1);
                    for (i = 0; i < sourceAlts.length; ++i) {
                        sourceAlleleValueMap.put(sourceAlts[i] + resourcePostfix, sourceValues[i].isEmpty() ? "." : sourceValues[i]);
                    }
                } else if (sourceAlts.length == 1) {
                    sourceAlleleValueMap.put(sourceAlts[0], sourceEntity.get(attribute.getName()).toString());
                }
            }
            StringBuilder newAttributeValue = new StringBuilder();
            String[] annotatedEntityAltAlleles = sourceEntity.getString("ALT").split(",");
            for (i = 0; i < annotatedEntityAltAlleles.length; ++i) {
                if (i != 0) {
                    newAttributeValue.append(",");
                }
                if (alleleValueMap.get(annotatedEntityAltAlleles[i] + sourcePostfix) != null) {
                    newAttributeValue.append((String)alleleValueMap.get(annotatedEntityAltAlleles[i] + sourcePostfix));
                    continue;
                }
                if (!updateMode) {
                    newAttributeValue.append(".");
                    continue;
                }
                if (sourceAlleleValueMap.get(annotatedEntityAltAlleles[i] + sourcePostfix) != null) {
                    newAttributeValue.append((String)sourceAlleleValueMap.get(annotatedEntityAltAlleles[i] + sourcePostfix));
                    continue;
                }
                newAttributeValue.append(".");
            }
            if (newAttributeValue.toString().matches("[\\.,]+")) continue;
            resourceEntity.set(attribute.getName(), (Object)newAttributeValue.toString());
            result.add(resourceEntity);
        }
        return result;
    }

    public Iterable<Entity> merge(Iterable<Entity> resourceEntities) {
        ArrayList<Entity> resourceEntitiesMerged = new ArrayList<Entity>();
        PeekingIterator resourceEntitiesIterator = Iterators.peekingIterator(resourceEntities.iterator());
        if (!resourceEntitiesIterator.hasNext()) {
            return resourceEntitiesMerged;
        }
        Location location = Location.create((Entity)resourceEntitiesIterator.peek());
        LinkedListMultimap refToMergedEntity = LinkedListMultimap.create();
        while (resourceEntitiesIterator.hasNext()) {
            Entity resourceEntity = (Entity)resourceEntitiesIterator.next();
            Location thisLoc = Location.create(resourceEntity);
            if (!location.equals(thisLoc)) {
                throw new MolgenisDataException("Mismatch in location! " + location + " vs " + thisLoc);
            }
            refToMergedEntity.put((Object)resourceEntity.getString("REF"), (Object)resourceEntity);
        }
        for (String refKey : refToMergedEntity.keySet()) {
            boolean first = true;
            Entity mergeWithMe = null;
            for (Entity entityToBeMerged : refToMergedEntity.get((Object)refKey)) {
                if (first) {
                    mergeWithMe = entityToBeMerged;
                    first = false;
                    continue;
                }
                mergeWithMe.set("ALT", (Object)(mergeWithMe.get("ALT").toString() + "," + entityToBeMerged.get("ALT").toString()));
                for (Attribute alleleSpecificAttributes : this.attributes) {
                    String attrName = alleleSpecificAttributes.getName();
                    mergeWithMe.set(attrName, (Object)(mergeWithMe.get(attrName).toString() + "," + entityToBeMerged.get(attrName).toString()));
                }
            }
            resourceEntitiesMerged.add(mergeWithMe);
        }
        return resourceEntitiesMerged;
    }
}

