/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.annotation.core.query;

import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import org.molgenis.data.Entity;
import org.molgenis.data.Query;
import org.molgenis.data.annotation.core.datastructures.Locus;
import org.molgenis.data.annotation.core.entity.QueryCreator;
import org.molgenis.data.meta.model.Attribute;
import org.molgenis.data.support.QueryImpl;
import org.molgenis.data.vcf.model.VcfAttributes;

public class LocusQueryCreator
implements QueryCreator {
    private final VcfAttributes vcfAttributes;

    public LocusQueryCreator(VcfAttributes vcfAttributes) {
        this.vcfAttributes = Objects.requireNonNull(vcfAttributes);
    }

    @Override
    public Query<Entity> createQuery(Entity entity) {
        String chromosome = entity.getString("#CHROM");
        Integer position = entity.getInt("POS");
        Locus locus = new Locus(chromosome, position);
        return LocusQueryCreator.createQuery(locus);
    }

    public static Query<Entity> createQuery(Locus locus) {
        return QueryImpl.EQ((String)"#CHROM", (Object)locus.getChrom()).and().eq("POS", (Object)locus.getPos());
    }

    @Override
    public Collection<Attribute> getRequiredAttributes() {
        return Arrays.asList(this.vcfAttributes.getChromAttribute(), this.vcfAttributes.getPosAttribute());
    }
}

