/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.annotation.core.resources.impl;

import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.molgenis.data.Entity;
import org.molgenis.data.MolgenisDataException;
import org.molgenis.data.Query;
import org.molgenis.data.QueryRule;
import org.molgenis.data.RepositoryCapability;
import org.molgenis.data.csv.CsvRepository;
import org.molgenis.data.meta.model.AttributeFactory;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.data.meta.model.EntityTypeFactory;
import org.molgenis.data.support.AbstractRepository;

public class GeneCsvRepository
extends AbstractRepository {
    private final CsvRepository repository;
    private final Map<Object, Entity> index = new HashMap<Object, Entity>();
    private final String sourceAttributeName;
    private final String targetAttributeName;

    public GeneCsvRepository(File file, String sourceAttributeName, String targetAttributeName, EntityTypeFactory entityTypeFactory, AttributeFactory attrMetaFactory, char separator) {
        this.repository = new CsvRepository(file, entityTypeFactory, attrMetaFactory, null, Character.valueOf(separator));
        this.sourceAttributeName = sourceAttributeName;
        this.targetAttributeName = targetAttributeName;
    }

    public Set<RepositoryCapability> getCapabilities() {
        return this.repository.getCapabilities();
    }

    public EntityType getEntityType() {
        return this.repository.getEntityType();
    }

    public Iterator<Entity> iterator() {
        return this.repository.iterator();
    }

    public Stream<Entity> findAll(Query<Entity> q) {
        if (q.getRules().isEmpty()) {
            return this.getIndex().values().stream();
        }
        if (q.getRules().size() != 1 || ((QueryRule)q.getRules().get(0)).getOperator() != QueryRule.Operator.EQUALS || !this.targetAttributeName.equals(((QueryRule)q.getRules().get(0)).getField())) {
            throw new MolgenisDataException("The only query allowed on this Repository is '" + this.targetAttributeName + " EQUALS'");
        }
        Entity result = this.getIndex().get(((QueryRule)q.getRules().get(0)).getValue());
        return result == null ? Stream.empty() : Stream.of(result);
    }

    private Map<Object, Entity> getIndex() {
        if (this.index.isEmpty()) {
            this.forEach(e -> {
                Object key = e.get(this.sourceAttributeName);
                if (key == null) {
                    throw new MolgenisDataException("Missing value for attribute [" + this.sourceAttributeName + "] in entity [" + e + "]");
                }
                this.index.put(key, (Entity)e);
            });
        }
        return this.index;
    }
}

