/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.annotation.core.resources.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.molgenis.data.Entity;
import org.molgenis.data.Query;
import org.molgenis.data.QueryRule;
import org.molgenis.data.annotation.core.resources.MultiResourceConfig;
import org.molgenis.data.annotation.core.resources.Resource;
import org.molgenis.data.annotation.core.resources.ResourceConfig;
import org.molgenis.data.annotation.core.resources.impl.RepositoryFactory;
import org.molgenis.data.annotation.core.resources.impl.ResourceImpl;

public abstract class MultiFileResource
implements Resource {
    private final String name;
    private final Map<String, ResourceImpl> resources = new HashMap<String, ResourceImpl>();
    private final MultiResourceConfig config;

    public MultiFileResource(String name, MultiResourceConfig config) {
        this.name = name;
        this.config = config;
    }

    private void initializeResources() {
        this.resources.clear();
        for (Map.Entry<String, ResourceConfig> chromConfig : this.config.getConfigs().entrySet()) {
            String key = chromConfig.getKey();
            this.resources.put(key, new ResourceImpl(this.name + key, () -> {
                ResourceConfig resourceConfig = this.config.getConfigs().get(key);
                if (resourceConfig == null) {
                    this.initializeResources();
                    return null;
                }
                File file = resourceConfig.getFile();
                return file;
            }){

                @Override
                public RepositoryFactory getRepositoryFactory() {
                    return MultiFileResource.this.getRepositoryFactory();
                }
            });
        }
    }

    private static Optional<Object> getFirstEqualsValueFor(String attributeName, Query<Entity> q) {
        return q.getRules().stream().filter(rule -> attributeName.equals(rule.getField())).filter(rule -> rule.getOperator() == QueryRule.Operator.EQUALS).findFirst().map(QueryRule::getValue);
    }

    @Override
    public boolean isAvailable() {
        if (this.resources.isEmpty()) {
            this.initializeResources();
        }
        return this.resources.values().stream().allMatch(ResourceImpl::isAvailable);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Iterable<Entity> findAll(Query<Entity> q) {
        this.isAvailable();
        return MultiFileResource.getFirstEqualsValueFor("#CHROM", q).map(Object::toString).filter(this.resources::containsKey).map(this.resources::get).map(resource -> resource.findAll(q)).orElse(new ArrayList());
    }
}

