/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.annotation.core.resources.impl;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.molgenis.data.Entity;
import org.molgenis.data.annotation.core.resources.MultiResourceConfig;
import org.molgenis.data.annotation.core.resources.ResourceConfig;
import org.molgenis.security.core.runas.RunAsSystemAspect;

public class MultiResourceConfigImpl
implements MultiResourceConfig {
    private final Entity molgenisSettings;
    private final String chromosomesProperty;
    private final String filePatternProperty;
    private final String rootDirectoryProperty;
    private final String overrideChromosomeFilesProperty;
    public static final String DEFAULT_CHROMOSOMES = "1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,Y,X";
    public static final String DEFAULT_PATTERN = "chr%s.vcf";
    public static final String DEFAULT_ROOT_DIRECTORY = File.separatorChar + "data" + File.separatorChar + "resources";

    public MultiResourceConfigImpl(String chromosomesProperty, String filePatternProperty, String rootDirectoryProperty, String overrideChromosomeFilesProperty, Entity molgenisSettings) {
        this.chromosomesProperty = chromosomesProperty;
        this.filePatternProperty = filePatternProperty;
        this.rootDirectoryProperty = rootDirectoryProperty;
        this.overrideChromosomeFilesProperty = overrideChromosomeFilesProperty;
        this.molgenisSettings = molgenisSettings;
    }

    public MultiResourceConfigImpl(String chromosomesProperty, String filePatternProperty, String folderProperty, Entity molgenisSettings) {
        this(chromosomesProperty, filePatternProperty, folderProperty, null, molgenisSettings);
    }

    @Override
    public Map<String, ResourceConfig> getConfigs() {
        String[] chromosomes = this.getSetting(this.chromosomesProperty, DEFAULT_CHROMOSOMES).split(",");
        final String pattern = this.getSetting(this.filePatternProperty, DEFAULT_PATTERN);
        final String folder = this.getSetting(this.rootDirectoryProperty, DEFAULT_ROOT_DIRECTORY);
        final Map<String, String> overrideChromosomeFilesMap = this.getOverrideChromosomeFiles();
        HashMap<String, ResourceConfig> configs = new HashMap<String, ResourceConfig>();
        for (final String chrom : chromosomes) {
            configs.put(chrom, new ResourceConfig(){
                private File file = null;

                @Override
                public File getFile() {
                    String filename = overrideChromosomeFilesMap.containsKey(chrom) ? (String)overrideChromosomeFilesMap.get(chrom) : String.format(pattern, chrom);
                    String pathname = folder + File.separatorChar + filename;
                    if (null == this.file || pathname.equals(this.file.getPath())) {
                        this.file = new File(folder + File.separatorChar + filename);
                    }
                    return this.file;
                }
            });
        }
        return configs;
    }

    private String getSetting(String name, String defaultValue) {
        String value = (String)RunAsSystemAspect.runAsSystem(() -> this.molgenisSettings.getString(name));
        return value != null ? value : defaultValue;
    }

    private Map<String, String> getOverrideChromosomeFiles() {
        HashMap<String, String> overrideChromosomeFilesMap = new HashMap<String, String>();
        if (null != this.overrideChromosomeFilesProperty && this.molgenisSettings.getString(this.overrideChromosomeFilesProperty) != null) {
            String overrideChromosomeFiles = this.getSetting(this.overrideChromosomeFilesProperty, "").trim();
            for (String keyValue : overrideChromosomeFiles.split(",")) {
                String[] pairs = keyValue.split(":", 2);
                overrideChromosomeFilesMap.put(pairs[0], pairs.length == 1 ? "" : pairs[1]);
            }
        }
        return overrideChromosomeFilesMap;
    }
}

