/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.annotation.core.resources.impl;

import java.io.File;
import org.molgenis.data.Entity;
import org.molgenis.data.Query;
import org.molgenis.data.Repository;
import org.molgenis.data.annotation.core.resources.Resource;
import org.molgenis.data.annotation.core.resources.ResourceConfig;
import org.molgenis.data.annotation.core.resources.impl.RepositoryFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ResourceImpl
implements Resource {
    private final String name;
    private final ResourceConfig config;
    private volatile File file;
    private volatile Repository<Entity> repository;
    private static final Logger LOG = LoggerFactory.getLogger(ResourceImpl.class);

    public ResourceImpl(String name, ResourceConfig config) {
        this.name = name;
        this.config = config;
    }

    @Override
    public synchronized boolean isAvailable() {
        File file;
        if (this.repository != null && this.needsRefresh()) {
            this.repository = null;
            this.file = null;
        }
        return (file = this.getFile()) != null && file.exists();
    }

    @Override
    public Iterable<Entity> findAll(Query<Entity> q) {
        return () -> this.getRepository().findAll(q).iterator();
    }

    private boolean needsRefresh() {
        boolean needsRefresh;
        File newFile = this.config.getFile();
        boolean bl = needsRefresh = this.file != null && !this.file.equals(newFile);
        if (needsRefresh) {
            this.repository = null;
            this.file = null;
        }
        return this.repository == null;
    }

    private Repository<Entity> getRepository() {
        if (this.repository == null && this.isAvailable()) {
            this.initialize();
        }
        return this.repository;
    }

    private synchronized void initialize() {
        RepositoryFactory repositoryFactory = this.getRepositoryFactory();
        if (this.isAvailable() && this.repository == null) {
            try {
                this.file = this.getFile();
                if (this.file != null) {
                    this.repository = repositoryFactory.createRepository(this.file);
                }
            }
            catch (Exception e) {
                LOG.warn("Resource {} failed to create Repository for file {}.", new Object[]{this.name, this.file, e});
            }
        }
    }

    private synchronized File getFile() {
        return this.config.getFile();
    }

    @Override
    public String getName() {
        return this.name;
    }
}

