/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.annotation.core.resources.impl;

import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.molgenis.data.DataService;
import org.molgenis.data.Entity;
import org.molgenis.data.Query;
import org.molgenis.data.annotation.core.resources.Resource;
import org.molgenis.data.annotation.core.resources.Resources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class ResourcesImpl
implements Resources {
    private static final Logger LOG = LoggerFactory.getLogger(ResourcesImpl.class);
    @Autowired
    private DataService dataService;
    @Autowired
    private ApplicationContext applicationContext;
    private Map<String, Resource> resources = null;

    @Override
    public boolean hasRepository(String entityTypeId) {
        this.getResources();
        return this.dataService.hasRepository(entityTypeId) || this.resources.containsKey(entityTypeId) && this.resources.get(entityTypeId).isAvailable();
    }

    @Override
    public Iterable<Entity> findAll(String name, Query<Entity> q) {
        this.getResources();
        if (this.resources.containsKey(name)) {
            try {
                return this.resources.get(name).findAll(q);
            }
            catch (Exception ex) {
                if (this.resources.get(name).isAvailable()) {
                    LOG.error("Error querying Resource {}.", (Object)name);
                    throw ex;
                }
                LOG.warn("Resource {} is unavailable, trying dataService instead.", (Object)name);
            }
        }
        return () -> this.dataService.findAll(name, q).iterator();
    }

    @Override
    public Set<String> getResourcesNames() {
        this.getResources();
        return this.resources.keySet();
    }

    private void getResources() {
        if (this.resources == null) {
            this.resources = this.applicationContext.getBeansOfType(Resource.class).values().stream().collect(Collectors.toMap(Resource::getName, r -> r));
        }
    }
}

