/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.annotation.core.resources.impl.emx;

import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.util.Spliterators;
import java.util.stream.StreamSupport;
import org.molgenis.data.Entity;
import org.molgenis.data.Repository;
import org.molgenis.data.RepositoryCollection;
import org.molgenis.data.annotation.core.resources.impl.RepositoryFactory;
import org.molgenis.data.excel.ExcelRepositoryCollection;
import org.molgenis.data.importer.MetaDataParser;
import org.molgenis.data.mem.InMemoryRepository;
import org.molgenis.data.meta.model.AttributeFactory;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.data.meta.model.EntityTypeFactory;

public class InMemoryRepositoryFactory
implements RepositoryFactory {
    private final AttributeFactory attributeFactory;
    private final EntityTypeFactory entityTypeFactory;
    private final String id;
    private final String name;
    private ExcelRepositoryCollection repositoryCollection = null;
    private final MetaDataParser parser;

    public InMemoryRepositoryFactory(String entityId, String name, MetaDataParser parser, EntityTypeFactory entityTypeFactory, AttributeFactory attributeFactory) {
        this.id = entityId;
        this.name = name;
        this.parser = parser;
        this.attributeFactory = attributeFactory;
        this.entityTypeFactory = entityTypeFactory;
    }

    @Override
    public Repository<Entity> createRepository(File file) throws IOException {
        try {
            this.repositoryCollection = new ExcelRepositoryCollection(file);
            this.repositoryCollection.setAttributeFactory(this.attributeFactory);
            this.repositoryCollection.setEntityTypeFactory(this.entityTypeFactory);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create ExcelRepositoryCollection for file:" + file.getName() + " exception: " + e);
        }
        ImmutableMap entityMap = this.parser.parse((RepositoryCollection)this.repositoryCollection, "base").getEntityMap();
        if (!entityMap.containsKey((Object)this.id)) {
            throw new RuntimeException("Entity [" + this.id + "] is not found. Entities found: " + entityMap.keySet());
        }
        EntityType metaData = (EntityType)entityMap.get((Object)this.id);
        InMemoryRepository inMemoryRepository = new InMemoryRepository(metaData);
        inMemoryRepository.add(StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.repositoryCollection.getRepository(this.name).iterator(), 16), false));
        return inMemoryRepository;
    }
}

