/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.annotation.core.resources.impl.tabix;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import net.sf.samtools.util.BlockCompressedInputStream;

public class TabixReader {
    private String filename;
    private BlockCompressedInputStream blockCompressedInputStream;
    private int mPreset;
    private int mSc;
    private int mBc;
    private int mEc;
    private int mMeta;
    private String[] mSeq;
    private TIndex[] mIndex;
    private HashMap<String, Integer> mChr2tid;
    private static int MAX_BIN = 37450;
    private static int TAD_MIN_CHUNK_GAP = 32768;
    private static int TAD_LIDX_SHIFT = 14;

    private static boolean less64(long u, long v) {
        return u < v ^ u < 0L ^ v < 0L;
    }

    public TabixReader(String filename) throws IOException {
        this.filename = filename;
        this.blockCompressedInputStream = new BlockCompressedInputStream(new File(filename));
        this.readIndex(filename);
    }

    private static int reg2bins(int beginposition, int endPosition, int[] list) {
        int i = 0;
        int end = endPosition;
        if (beginposition >= end) {
            return 0;
        }
        if (end >= 0x20000000) {
            end = 0x20000000;
        }
        --end;
        list[i++] = 0;
        int k = 1 + (beginposition >> 26);
        while (k <= 1 + (end >> 26)) {
            list[i++] = k++;
        }
        k = 9 + (beginposition >> 23);
        while (k <= 9 + (end >> 23)) {
            list[i++] = k++;
        }
        k = 73 + (beginposition >> 20);
        while (k <= 73 + (end >> 20)) {
            list[i++] = k++;
        }
        k = 585 + (beginposition >> 17);
        while (k <= 585 + (end >> 17)) {
            list[i++] = k++;
        }
        k = 4681 + (beginposition >> 14);
        while (k <= 4681 + (end >> 14)) {
            list[i++] = k++;
        }
        return i;
    }

    public static int readInt(InputStream is) throws IOException {
        byte[] buf = new byte[4];
        is.read(buf);
        return ByteBuffer.wrap(buf).order(ByteOrder.LITTLE_ENDIAN).getInt();
    }

    public static long readLong(InputStream is) throws IOException {
        byte[] buf = new byte[8];
        is.read(buf);
        return ByteBuffer.wrap(buf).order(ByteOrder.LITTLE_ENDIAN).getLong();
    }

    public static String readLine(InputStream is) throws IOException {
        int c;
        StringBuilder buf = new StringBuilder();
        while ((c = is.read()) >= 0 && c != 10) {
            buf.append((char)c);
        }
        if (c < 0) {
            return null;
        }
        return buf.toString();
    }

    public void readIndex(File file) throws IOException {
        int i;
        if (file == null) {
            return;
        }
        BlockCompressedInputStream is = new BlockCompressedInputStream(file);
        byte[] buf = new byte[4];
        is.read(buf, 0, 4);
        this.mSeq = new String[TabixReader.readInt((InputStream)is)];
        this.mChr2tid = new HashMap();
        this.mPreset = TabixReader.readInt((InputStream)is);
        this.mSc = TabixReader.readInt((InputStream)is);
        this.mBc = TabixReader.readInt((InputStream)is);
        this.mEc = TabixReader.readInt((InputStream)is);
        this.mMeta = TabixReader.readInt((InputStream)is);
        int mSkip = TabixReader.readInt((InputStream)is);
        int l = TabixReader.readInt((InputStream)is);
        buf = new byte[l];
        is.read(buf);
        int k = 0;
        int j = 0;
        for (i = 0; i < buf.length; ++i) {
            if (buf[i] != 0) continue;
            byte[] b = new byte[i - j];
            System.arraycopy(buf, j, b, 0, b.length);
            String s = new String(b, StandardCharsets.UTF_8);
            this.mChr2tid.put(s, k);
            this.mSeq[k++] = s;
            j = i + 1;
        }
        this.mIndex = new TIndex[this.mSeq.length];
        for (i = 0; i < this.mSeq.length; ++i) {
            int n_bin = TabixReader.readInt((InputStream)is);
            this.mIndex[i] = new TIndex();
            this.mIndex[i].b = new HashMap();
            for (j = 0; j < n_bin; ++j) {
                int bin = TabixReader.readInt((InputStream)is);
                TPair64[] chunks = new TPair64[TabixReader.readInt((InputStream)is)];
                for (k = 0; k < chunks.length; ++k) {
                    long u = TabixReader.readLong((InputStream)is);
                    long v = TabixReader.readLong((InputStream)is);
                    chunks[k] = new TPair64(u, v);
                }
                this.mIndex[i].b.put(bin, chunks);
            }
            this.mIndex[i].l = new long[TabixReader.readInt((InputStream)is)];
            for (k = 0; k < this.mIndex[i].l.length; ++k) {
                this.mIndex[i].l[k] = TabixReader.readLong((InputStream)is);
            }
        }
        is.close();
    }

    public void readIndex(String fileName) throws IOException {
        this.readIndex(new File(this.filename + ".tbi"));
    }

    public String readLine() throws IOException {
        return TabixReader.readLine((InputStream)this.blockCompressedInputStream);
    }

    private int chr2tid(String chr) {
        return this.mChr2tid.getOrDefault(chr, -1);
    }

    private int[] parseReg(String queryString) {
        String chr;
        int[] ret = new int[3];
        int colon = queryString.indexOf(58);
        int hyphen = queryString.indexOf(45);
        String string = chr = colon >= 0 ? queryString.substring(0, colon) : queryString;
        ret[1] = colon >= 0 ? Integer.parseInt(queryString.substring(colon + 1, hyphen >= 0 ? hyphen : queryString.length())) - 1 : 0;
        ret[2] = hyphen >= 0 ? Integer.parseInt(queryString.substring(hyphen + 1)) : Integer.MAX_VALUE;
        ret[0] = this.chr2tid(chr);
        return ret;
    }

    private TIntv getIntv(String s) {
        TIntv intv = new TIntv();
        int col = 0;
        int end = 0;
        int beg = 0;
        while ((end = s.indexOf(9, beg)) >= 0 || end == -1) {
            if (++col == this.mSc) {
                intv.internalChromosomeID = this.chr2tid(s.substring(beg, end));
            } else if (col == this.mBc) {
                intv.end = Integer.parseInt(s.substring(beg, end == -1 ? s.length() : end));
                intv.beginPosition = intv.end++;
                if ((this.mPreset & 0x10000) == 0) {
                    --intv.beginPosition;
                }
                if (intv.beginPosition < 0) {
                    intv.beginPosition = 0;
                }
                if (intv.end < 1) {
                    intv.end = 1;
                }
            } else if ((this.mPreset & 0xFFFF) == 0) {
                if (col == this.mEc) {
                    intv.end = Integer.parseInt(s.substring(beg, end));
                }
            } else if ((this.mPreset & 0xFFFF) == 1) {
                if (col == 6) {
                    int l = 0;
                    String cigar = s.substring(beg, end);
                    int j = 0;
                    for (int i = 0; i < cigar.length(); ++i) {
                        char op;
                        if (cigar.charAt(i) <= '9' || (op = cigar.charAt(i)) != 'M' && op != 'D' && op != 'N') continue;
                        l += Integer.parseInt(cigar.substring(j, i));
                    }
                    intv.end = intv.beginPosition + l;
                }
            } else if ((this.mPreset & 0xFFFF) == 2) {
                String alt;
                String string = alt = end >= 0 ? s.substring(beg, end) : s.substring(beg);
                if (col == 4) {
                    if (alt.length() > 0) {
                        intv.end = intv.beginPosition + alt.length();
                    }
                } else if (col == 8) {
                    int e_off = -1;
                    int i = alt.indexOf("END=");
                    if (i == 0) {
                        e_off = 4;
                    } else if (i > 0 && (i = alt.indexOf(";END=")) >= 0) {
                        e_off = i + 5;
                    }
                    if (e_off > 0) {
                        i = alt.indexOf(";", e_off);
                        intv.end = Integer.parseInt(i > e_off ? alt.substring(e_off, i) : alt.substring(e_off));
                    }
                }
            }
            if (end == -1) break;
            beg = end + 1;
        }
        return intv;
    }

    public Iterator query(int internalChromosomeID, int beginPosition, int endPosition) {
        TPair64[] chunks;
        int i;
        TIndex idx = this.mIndex[internalChromosomeID];
        int[] bins = new int[MAX_BIN];
        int n_bins = TabixReader.reg2bins(beginPosition, endPosition, bins);
        long min_off = idx.l.length > 0 ? (beginPosition >> TAD_LIDX_SHIFT >= idx.l.length ? idx.l[idx.l.length - 1] : idx.l[beginPosition >> TAD_LIDX_SHIFT]) : 0L;
        int n_off = 0;
        for (i = 0; i < n_bins; ++i) {
            chunks = idx.b.get(bins[i]);
            if (chunks == null) continue;
            n_off += chunks.length;
        }
        if (n_off == 0) {
            return null;
        }
        Object[] off = new TPair64[n_off];
        n_off = 0;
        for (i = 0; i < n_bins; ++i) {
            chunks = idx.b.get(bins[i]);
            if (chunks == null) continue;
            for (TPair64 chunk : chunks) {
                if (!TabixReader.less64(min_off, chunk.v)) continue;
                off[n_off++] = new TPair64(chunk);
            }
        }
        if (n_off == 0) {
            return null;
        }
        Arrays.sort(off, 0, n_off);
        int l = 0;
        for (i = 1; i < n_off; ++i) {
            if (!TabixReader.less64(((TPair64)off[l]).v, ((TPair64)off[i]).v)) continue;
            ((TPair64)off[++l]).u = ((TPair64)off[i]).u;
            ((TPair64)off[l]).v = ((TPair64)off[i]).v;
        }
        n_off = l + 1;
        for (i = 1; i < n_off; ++i) {
            if (TabixReader.less64(((TPair64)off[i - 1]).v, ((TPair64)off[i]).u)) continue;
            ((TPair64)off[i - 1]).v = ((TPair64)off[i]).u;
        }
        l = 0;
        for (i = 1; i < n_off; ++i) {
            if (((TPair64)off[l]).v >> 16 == ((TPair64)off[i]).u >> 16) {
                ((TPair64)off[l]).v = ((TPair64)off[i]).v;
                continue;
            }
            ((TPair64)off[++l]).u = ((TPair64)off[i]).u;
            ((TPair64)off[l]).v = ((TPair64)off[i]).v;
        }
        n_off = l + 1;
        TPair64[] ret = new TPair64[n_off];
        for (i = 0; i < n_off; ++i) {
            ret[i] = new TPair64(((TPair64)off[i]).u, ((TPair64)off[i]).v);
        }
        return new Iterator(internalChromosomeID, beginPosition, endPosition, ret);
    }

    public Iterator query(String queryString) {
        int[] x = this.parseReg(queryString);
        int beginPosition = x[0];
        int endPosition = x[1];
        int internalChromosomeID = x[2];
        return this.query(beginPosition, endPosition, internalChromosomeID);
    }

    public class Iterator {
        private int i = -1;
        private final int internalChromosomeID;
        private final int beginPosition;
        private final int endPosition;
        private final TPair64[] off;
        private long curr_off = 0L;
        private boolean isEndOfFile = false;

        public Iterator(int _tid, int _beg, int _end, TPair64[] _off) {
            this.off = _off;
            this.internalChromosomeID = _tid;
            this.beginPosition = _beg;
            this.endPosition = _end;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String next() throws IOException {
            if (this.isEndOfFile) {
                return null;
            }
            while (true) {
                BlockCompressedInputStream blockCompressedInputStream = TabixReader.this.blockCompressedInputStream;
                synchronized (blockCompressedInputStream) {
                    if (this.curr_off == 0L || !TabixReader.less64(this.curr_off, this.off[this.i].v)) {
                        if (this.i == this.off.length - 1) {
                            break;
                        }
                        if (this.i >= 0) assert (this.curr_off == this.off[this.i].v);
                        if (this.i < 0 || this.off[this.i].v != this.off[this.i + 1].u) {
                            TabixReader.this.blockCompressedInputStream.seek(this.off[this.i + 1].u);
                            this.curr_off = TabixReader.this.blockCompressedInputStream.getFilePointer();
                        }
                        ++this.i;
                    } else {
                        TabixReader.this.blockCompressedInputStream.seek(this.curr_off);
                    }
                    String s = TabixReader.readLine((InputStream)TabixReader.this.blockCompressedInputStream);
                    if (s != null) {
                        char[] str = s.toCharArray();
                        this.curr_off = TabixReader.this.blockCompressedInputStream.getFilePointer();
                        if (str.length == 0 || str[0] == TabixReader.this.mMeta) {
                            continue;
                        }
                        TIntv intv = TabixReader.this.getIntv(s);
                        if (intv.internalChromosomeID != this.internalChromosomeID || intv.beginPosition >= this.endPosition) {
                            break;
                        }
                        if (intv.end > this.beginPosition && intv.beginPosition < this.endPosition) {
                            return s;
                        }
                    } else {
                        break;
                    }
                }
            }
            this.isEndOfFile = true;
            return null;
        }
    }

    private class TIntv {
        int internalChromosomeID;
        int beginPosition;
        int end;

        private TIntv() {
        }
    }

    private class TIndex {
        HashMap<Integer, TPair64[]> b;
        long[] l;

        private TIndex() {
        }
    }

    private class TPair64
    implements Comparable<TPair64> {
        long u;
        long v;

        public TPair64(long _u, long _v) {
            this.u = _u;
            this.v = _v;
        }

        public TPair64(TPair64 p) {
            this.u = p.u;
            this.v = p.v;
        }

        @Override
        public int compareTo(TPair64 p) {
            return this.u == p.u ? 0 : (this.u < p.u ^ this.u < 0L ^ p.u < 0L ? -1 : 1);
        }
    }
}

