/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.annotation.core.resources.impl.tabix;

import au.com.bytecode.opencsv.CSVParser;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.molgenis.data.DataConverter;
import org.molgenis.data.Entity;
import org.molgenis.data.Query;
import org.molgenis.data.RepositoryCapability;
import org.molgenis.data.annotation.core.resources.impl.tabix.TabixReader;
import org.molgenis.data.meta.model.Attribute;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.data.support.AbstractRepository;
import org.molgenis.data.support.DynamicEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TabixRepository
extends AbstractRepository {
    private static final Logger LOG = LoggerFactory.getLogger(TabixRepository.class);
    private TabixReader reader;
    private EntityType entityType;
    private final String chromosomeAttributeName;
    private final String positionAttributeName;

    public TabixRepository(File file, EntityType entityType) throws IOException {
        this(file, entityType, "#CHROM", "POS");
    }

    public TabixRepository(File file, EntityType entityType, String chromosomeAttributeName, String positionAttributeName) throws IOException {
        this.entityType = entityType;
        this.reader = new TabixReader(file.getAbsolutePath());
        this.chromosomeAttributeName = Objects.requireNonNull(chromosomeAttributeName);
        this.positionAttributeName = Objects.requireNonNull(positionAttributeName);
    }

    TabixRepository(TabixReader reader, EntityType entityType, String chromosomeAttributeName, String positionAttributeName) {
        this.reader = Objects.requireNonNull(reader);
        this.entityType = Objects.requireNonNull(entityType);
        this.chromosomeAttributeName = Objects.requireNonNull(chromosomeAttributeName);
        this.positionAttributeName = Objects.requireNonNull(positionAttributeName);
    }

    public static CSVParser getCsvParser() {
        return new CSVParser('\t');
    }

    public Set<RepositoryCapability> getCapabilities() {
        return Collections.singleton(RepositoryCapability.QUERYABLE);
    }

    public EntityType getEntityType() {
        return this.entityType;
    }

    public Stream<Entity> findAll(Query<Entity> q) {
        Object posValue = TabixRepository.getFirstEqualsValueFor(this.positionAttributeName, q);
        Object chromValue = TabixRepository.getFirstEqualsValueFor(this.chromosomeAttributeName, q);
        ArrayList result = new ArrayList();
        if (posValue != null && chromValue != null) {
            int posIntValue = Integer.parseInt(posValue.toString());
            String chromStringValue = chromValue.toString();
            result = this.query(chromStringValue, posIntValue);
        }
        return result.stream();
    }

    private synchronized ImmutableList<Entity> query(String chrom, int pos) {
        ImmutableList.Builder builder;
        block8: {
            String queryString = String.format("%s:%s-%2$s", chrom, pos);
            LOG.debug("query({})", (Object)queryString);
            builder = ImmutableList.builder();
            try {
                TabixReader.Iterator iterator = this.reader.query(queryString);
                if (iterator != null) {
                    String line = iterator.next();
                    while (line != null) {
                        Entity entity = this.toEntity(line);
                        if (entity.getInt(this.positionAttributeName) == pos) {
                            builder.add((Object)entity);
                        } else {
                            LOG.warn("TabixReader returns entity that does not match the query!");
                        }
                        line = iterator.next();
                    }
                    break block8;
                }
                return ImmutableList.of();
            }
            catch (IOException e) {
                LOG.error("Error reading from tabix resource", (Throwable)e);
            }
            catch (NullPointerException e) {
                LOG.trace("Unable to read from tabix resource for query: " + queryString + " (Position not present in resource file?)");
                LOG.debug("", (Throwable)e);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                LOG.trace("Unable to read from tabix resource for query: " + queryString + " (Chromosome not present in resource file?)");
                LOG.debug("", (Throwable)e);
            }
        }
        return builder.build();
    }

    private static Object getFirstEqualsValueFor(String attributeName, Query<Entity> q) {
        return q.getRules().stream().filter(rule -> attributeName.equals(rule.getField())).findFirst().get().getValue();
    }

    protected Entity toEntity(String line) throws IOException {
        DynamicEntity result = new DynamicEntity(this.entityType);
        CSVParser csvParser = TabixRepository.getCsvParser();
        String[] columns = csvParser.parseLine(line);
        int i = 0;
        for (Attribute amd : this.entityType.getAtomicAttributes()) {
            if (i >= columns.length) continue;
            result.set(amd.getName(), DataConverter.convert((Object)columns[i++], (Attribute)amd));
        }
        return result;
    }

    public Iterator<Entity> iterator() {
        return new TabixRepositoryIterator();
    }

    private class TabixRepositoryIterator
    implements Iterator<Entity> {
        private String nextLine = null;

        private TabixRepositoryIterator() {
        }

        @Override
        public boolean hasNext() {
            if (this.nextLine != null) {
                return true;
            }
            try {
                this.nextLine = TabixRepository.this.reader.readLine();
                return this.nextLine != null;
            }
            catch (IOException e) {
                return false;
            }
        }

        @Override
        public Entity next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            try {
                Entity entity = TabixRepository.this.toEntity(this.nextLine);
                return entity;
            }
            catch (IOException e) {
                throw new NoSuchElementException();
            }
            finally {
                this.nextLine = null;
            }
        }
    }
}

