/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.annotation.core.resources.impl.tabix;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.molgenis.data.Entity;
import org.molgenis.data.Query;
import org.molgenis.data.QueryRule;
import org.molgenis.data.RepositoryCapability;
import org.molgenis.data.annotation.core.resources.impl.tabix.TabixReader;
import org.molgenis.data.meta.model.AttributeFactory;
import org.molgenis.data.meta.model.EntityTypeFactory;
import org.molgenis.data.vcf.VcfReaderFactory;
import org.molgenis.data.vcf.VcfRepository;
import org.molgenis.data.vcf.format.VcfToEntity;
import org.molgenis.data.vcf.model.VcfAttributes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TabixVcfRepository
extends VcfRepository {
    private static final Logger LOG = LoggerFactory.getLogger(TabixVcfRepository.class);
    private final TabixReader tabixReader;

    public TabixVcfRepository(File file, String entityTypeId, VcfAttributes vcfAttributes, EntityTypeFactory entityTypeFactory, AttributeFactory attrMetaFactory) throws IOException {
        super(file, entityTypeId, vcfAttributes, entityTypeFactory, attrMetaFactory);
        this.tabixReader = new TabixReader(file.getCanonicalPath());
    }

    TabixVcfRepository(VcfReaderFactory readerFactory, TabixReader tabixReader, String entityTypeId, VcfAttributes vcfAttributes, EntityTypeFactory entityTypeFactory, AttributeFactory attrMetaFactory) {
        super(readerFactory, entityTypeId, vcfAttributes, entityTypeFactory, attrMetaFactory);
        this.tabixReader = tabixReader;
    }

    public Set<RepositoryCapability> getCapabilities() {
        return Collections.emptySet();
    }

    private static Object getFirstEqualsValueFor(String attributeName, Query<Entity> q) {
        return q.getRules().stream().filter(rule -> attributeName.equals(rule.getField()) && rule.getOperator() == QueryRule.Operator.EQUALS).findFirst().get().getValue();
    }

    public Stream<Entity> findAll(Query<Entity> q) {
        Object posValue = TabixVcfRepository.getFirstEqualsValueFor("POS", q);
        Object chromValue = TabixVcfRepository.getFirstEqualsValueFor("#CHROM", q);
        List<Object> result = new ArrayList();
        if (posValue != null && chromValue != null) {
            int posIntValue = Integer.parseInt(posValue.toString());
            String chromStringValue = chromValue.toString();
            result = this.query(chromStringValue, posIntValue, posIntValue);
        }
        return result.stream();
    }

    public synchronized List<Entity> query(String chrom, int posFrom, int posTo) {
        String queryString = String.format("%s:%s-%s", Preconditions.checkNotNull((Object)chrom), Preconditions.checkNotNull((Object)posFrom), Preconditions.checkNotNull((Object)posTo));
        try {
            Collection<String> lines = this.getLines(this.tabixReader.query(queryString));
            return lines.stream().map(line -> line.split("\t")).map(arg_0 -> ((VcfToEntity)((VcfToEntity)this.vcfToEntitySupplier.get())).toEntity(arg_0)).filter(entity -> this.positionMatches((Entity)entity, posFrom, posTo)).collect(Collectors.toList());
        }
        catch (NullPointerException e) {
            LOG.trace("Unable to read from tabix resource for query: " + queryString + " (Position not present in resource file?)");
            LOG.debug("", (Throwable)e);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            LOG.trace("Unable to read from tabix resource for query: " + queryString + " (Chromosome not present in resource file?)");
            LOG.debug("", (Throwable)e);
        }
        return Collections.emptyList();
    }

    private boolean positionMatches(Entity entity, int posFrom, int posTo) {
        int entityPos = entity.getInt("POS");
        return entityPos >= posFrom && entityPos <= posTo;
    }

    protected Collection<String> getLines(TabixReader.Iterator iterator) {
        ImmutableList.Builder builder = ImmutableList.builder();
        if (iterator != null) {
            try {
                String line = iterator.next();
                while (line != null) {
                    builder.add((Object)line);
                    line = iterator.next();
                }
            }
            catch (IOException e) {
                LOG.error("Error reading from tabix reader.", (Throwable)e);
            }
        }
        return builder.build();
    }
}

