/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.annotation.core.resources.impl.tabix;

import java.io.File;
import java.io.IOException;
import java.util.Objects;
import org.molgenis.data.Entity;
import org.molgenis.data.Repository;
import org.molgenis.data.annotation.core.resources.impl.RepositoryFactory;
import org.molgenis.data.annotation.core.resources.impl.tabix.TabixVcfRepository;
import org.molgenis.data.meta.model.AttributeFactory;
import org.molgenis.data.meta.model.EntityTypeFactory;
import org.molgenis.data.vcf.model.VcfAttributes;

public class TabixVcfRepositoryFactory
implements RepositoryFactory {
    private final String name;
    private VcfAttributes vcfAttributes;
    private EntityTypeFactory entityTypeFactory;
    private AttributeFactory attributeFactory;

    public TabixVcfRepositoryFactory(String name, VcfAttributes vcfAttributes, EntityTypeFactory entityTypeFactory, AttributeFactory attrMetaFactory) {
        this.name = Objects.requireNonNull(name);
        this.entityTypeFactory = Objects.requireNonNull(entityTypeFactory);
        this.attributeFactory = Objects.requireNonNull(attrMetaFactory);
        this.vcfAttributes = Objects.requireNonNull(vcfAttributes);
    }

    @Override
    public Repository<Entity> createRepository(File file) throws IOException {
        return new TabixVcfRepository(file, this.name, this.vcfAttributes, this.entityTypeFactory, this.attributeFactory);
    }
}

