/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.annotation.core.utils;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.stream.Collectors;
import org.molgenis.data.Entity;
import org.molgenis.data.Repository;
import org.molgenis.data.annotation.core.EffectBasedAnnotator;
import org.molgenis.data.annotation.core.RepositoryAnnotator;
import org.molgenis.data.annotation.core.exception.UnresolvedAnnotatorDependencyException;
import org.molgenis.data.meta.AttributeType;
import org.molgenis.data.meta.model.Attribute;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.data.meta.model.EntityTypeFactory;

public class AnnotatorDependencyOrderResolver {
    private RepositoryAnnotator requestedAnnotator;

    public Queue<RepositoryAnnotator> getAnnotatorSelectionDependencyList(List<RepositoryAnnotator> availableAnnotatorList, List<RepositoryAnnotator> requestedAnnotatorList, Repository<Entity> repo, EntityTypeFactory entityTypeFactory) {
        Queue<RepositoryAnnotator> sortedList = new LinkedList<RepositoryAnnotator>();
        for (RepositoryAnnotator annotator : requestedAnnotatorList) {
            if (annotator instanceof EffectBasedAnnotator) {
                sortedList.add(annotator);
                continue;
            }
            if (sortedList.contains(annotator)) continue;
            this.requestedAnnotator = annotator;
            sortedList = this.getSingleAnnotatorDependencyList(annotator, availableAnnotatorList, sortedList, repo.getEntityType(), entityTypeFactory);
        }
        return sortedList;
    }

    private Queue<RepositoryAnnotator> getSingleAnnotatorDependencyList(RepositoryAnnotator selectedAnnotator, List<RepositoryAnnotator> annotatorList, Queue<RepositoryAnnotator> queue, EntityType emd, EntityTypeFactory entityTypeFactory) {
        EntityType entityType = (EntityType)entityTypeFactory.create((Entity)emd);
        this.resolveAnnotatorDependencies(selectedAnnotator, annotatorList, queue, entityType);
        return queue;
    }

    private void resolveAnnotatorDependencies(RepositoryAnnotator selectedAnnotator, List<RepositoryAnnotator> annotatorList, Queue<RepositoryAnnotator> annotatorQueue, EntityType entityType) {
        if (!this.areRequiredAttributesAvailable(Lists.newArrayList((Iterable)entityType.getAtomicAttributes()), selectedAnnotator.getRequiredAttributes())) {
            selectedAnnotator.getRequiredAttributes().stream().filter(requiredInputAttribute -> !this.areRequiredAttributesAvailable(Lists.newArrayList((Iterable)entityType.getAtomicAttributes()), Collections.singletonList(requiredInputAttribute))).forEachOrdered(requiredInputAttribute -> annotatorList.stream().filter(a -> !a.equals(selectedAnnotator)).collect(Collectors.toList()).forEach(annotator -> this.resolveAnnotatorDependencies(selectedAnnotator, annotatorList, annotatorQueue, entityType, (Attribute)requiredInputAttribute, (RepositoryAnnotator)annotator)));
        } else {
            if (!annotatorQueue.contains(selectedAnnotator)) {
                annotatorQueue.add(selectedAnnotator);
            }
            if (!selectedAnnotator.equals(this.requestedAnnotator)) {
                this.resolveAnnotatorDependencies(this.requestedAnnotator, annotatorList, annotatorQueue, entityType);
            }
        }
        if (annotatorQueue.isEmpty()) {
            throw new UnresolvedAnnotatorDependencyException("unsolved for: " + this.requestedAnnotator);
        }
    }

    private void resolveAnnotatorDependencies(RepositoryAnnotator selectedAnnotator, List<RepositoryAnnotator> annotatorList, Queue<RepositoryAnnotator> annotatorQueue, EntityType entityType, Attribute requiredAttribute, RepositoryAnnotator annotator) {
        if (this.isRequiredAttributeAvailable(annotator.getInfo().getOutputAttributes(), requiredAttribute)) {
            if (this.areRequiredAttributesAvailable(Lists.newArrayList((Iterable)entityType.getAtomicAttributes()), annotator.getRequiredAttributes())) {
                if (!annotatorQueue.contains(selectedAnnotator)) {
                    annotatorQueue.add(annotator);
                }
                annotator.getInfo().getOutputAttributes().forEach(x$0 -> entityType.addAttribute(x$0, new EntityType.AttributeRole[0]));
                annotatorList.remove(annotator);
                this.resolveAnnotatorDependencies(this.requestedAnnotator, annotatorList, annotatorQueue, entityType);
            } else {
                this.resolveAnnotatorDependencies(annotator, annotatorList, annotatorQueue, entityType);
            }
        }
    }

    private boolean areRequiredAttributesAvailable(List<Attribute> availableAttributes, List<Attribute> requiredAttributes) {
        for (Attribute attr : requiredAttributes) {
            if (this.isRequiredAttributeAvailable(availableAttributes, attr)) continue;
            return false;
        }
        return true;
    }

    private boolean isRequiredAttributeAvailable(List<Attribute> availableAttributes, Attribute requiredAttribute) {
        for (Attribute availableAttribute : availableAttributes) {
            if (!requiredAttribute.getName().equals(availableAttribute.getName())) continue;
            if (requiredAttribute.getDataType() == AttributeType.TEXT) {
                return availableAttribute.getDataType() == AttributeType.TEXT || availableAttribute.getDataType() == AttributeType.STRING;
            }
            return requiredAttribute.getDataType() == availableAttribute.getDataType();
        }
        return false;
    }
}

