/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.annotation.core.utils;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.molgenis.data.MolgenisDataException;
import org.molgenis.data.annotation.core.RepositoryAnnotator;
import org.molgenis.data.meta.AttributeType;
import org.molgenis.data.meta.model.Attribute;
import org.molgenis.data.meta.model.AttributeFactory;
import org.molgenis.data.meta.model.EntityType;

public class AnnotatorUtils {
    public static String getAnnotatorResourceDir() {
        String molgenisHomeDir = System.getProperty("molgenis.home");
        if (molgenisHomeDir != null) {
            if (!molgenisHomeDir.endsWith("/")) {
                molgenisHomeDir = molgenisHomeDir + '/';
            }
            return molgenisHomeDir + "data/annotation_resources";
        }
        return null;
    }

    public static Map<String, Double> toAlleleMap(String alternatives, String annotations) {
        if (annotations == null) {
            annotations = "";
        }
        if (alternatives == null) {
            return Collections.emptyMap();
        }
        String[] altArray = alternatives.split(",");
        String[] annotationsArray = annotations.split(",");
        HashMap<String, Double> result = new HashMap<String, Double>();
        if (altArray.length == annotationsArray.length) {
            for (int i = 0; i < altArray.length; ++i) {
                Double value = null;
                if (StringUtils.isNotEmpty((CharSequence)annotationsArray[i])) {
                    value = Double.parseDouble(annotationsArray[i]);
                }
                result.put(altArray[i], value);
            }
        } else if (StringUtils.isEmpty((CharSequence)annotations)) {
            for (String anAltArray : altArray) {
                result.put(anAltArray, null);
            }
        } else {
            throw new MolgenisDataException("ALT differs in length from the provided annotations.");
        }
        return result;
    }

    public static EntityType addAnnotatorMetaDataToRepositories(EntityType entityType, AttributeFactory attributeFactory, RepositoryAnnotator annotator) {
        List<Attribute> attributes = annotator.createAnnotatorAttributes(attributeFactory);
        String compoundName = annotator.getFullName();
        Attribute compound = entityType.getAttribute(compoundName);
        if (compound == null) {
            AnnotatorUtils.createCompoundForAnnotator(entityType, attributeFactory, annotator, attributes, compoundName);
        }
        return entityType;
    }

    private static void createCompoundForAnnotator(EntityType entityType, AttributeFactory attributeFactory, RepositoryAnnotator annotator, List<Attribute> attributes, String compoundName) {
        Attribute compound = attributeFactory.create().setName(compoundName).setLabel(annotator.getFullName()).setDataType(AttributeType.COMPOUND).setLabel(annotator.getSimpleName());
        attributes.stream().filter(part -> entityType.getAttribute(part.getName()) == null).forEachOrdered(part -> part.setParent(compound));
        entityType.addAttribute(compound, new EntityType.AttributeRole[0]);
        attributes = attributes.stream().filter(attribute -> entityType.getAttribute(attribute.getName()) == null).collect(Collectors.toList());
        entityType.addAttributes(attributes);
    }
}

