/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.annotation.core.utils;

import com.google.common.collect.Lists;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.sf.samtools.util.BlockCompressedOutputStream;
import org.molgenis.data.Entity;
import org.molgenis.data.MolgenisInvalidFormatException;
import org.molgenis.data.annotation.core.EffectBasedAnnotator;
import org.molgenis.data.annotation.core.EffectCreatingAnnotator;
import org.molgenis.data.annotation.core.RepositoryAnnotator;
import org.molgenis.data.annotation.core.utils.AnnotatorUtils;
import org.molgenis.data.annotation.core.utils.EffectStructureConverter;
import org.molgenis.data.meta.AttributeType;
import org.molgenis.data.meta.model.Attribute;
import org.molgenis.data.meta.model.AttributeFactory;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.data.meta.model.EntityTypeFactory;
import org.molgenis.data.vcf.VcfRepository;
import org.molgenis.data.vcf.model.VcfAttributes;
import org.molgenis.data.vcf.utils.VcfUtils;
import org.molgenis.data.vcf.utils.VcfWriterUtils;

public class CmdLineAnnotatorUtils {
    private static final String EFFECT = "EFFECT";

    public static String annotate(RepositoryAnnotator annotator, VcfAttributes vcfAttributes, EntityTypeFactory entityTypeFactory, AttributeFactory attributeFactory, EffectStructureConverter effectStructureConverter, File inputVcfFile, File outputVCFFile, List<String> attributesToInclude, boolean update) throws IOException, MolgenisInvalidFormatException {
        try (BufferedWriter outputVCFWriter = CmdLineAnnotatorUtils.createBufferedWriter(outputVCFFile);
             VcfRepository vcfRepo = new VcfRepository(inputVcfFile, inputVcfFile.getName(), vcfAttributes, entityTypeFactory, attributeFactory);){
            List<Attribute> outputMetaData = CmdLineAnnotatorUtils.getOutputAttributeMetadatasForAnnotator(annotator, entityTypeFactory, attributeFactory, attributesToInclude, vcfRepo);
            VcfWriterUtils.writeVcfHeader((File)inputVcfFile, (BufferedWriter)outputVCFWriter, (List)VcfUtils.getAtomicAttributesFromList(outputMetaData), attributesToInclude);
            Iterable<Entity> entitiesToAnnotate = CmdLineAnnotatorUtils.addAnnotatorMetaDataToRepository(annotator, attributeFactory, effectStructureConverter, vcfRepo);
            Iterator<Entity> annotatedRecords = CmdLineAnnotatorUtils.annotateRepo(annotator, effectStructureConverter, update, entitiesToAnnotate);
            CmdLineAnnotatorUtils.writeAnnotationResultToVcfFile(attributesToInclude, outputVCFWriter, outputMetaData, annotatedRecords);
        }
        return outputVCFFile.getAbsolutePath();
    }

    private static BufferedWriter createBufferedWriter(File outputVCFFile) throws IOException {
        Object outputStream = outputVCFFile.getName().endsWith(".gz") ? new BlockCompressedOutputStream(outputVCFFile) : new FileOutputStream(outputVCFFile);
        return new BufferedWriter(new OutputStreamWriter((OutputStream)outputStream, StandardCharsets.UTF_8));
    }

    private static Iterator<Entity> annotateRepo(RepositoryAnnotator annotator, EffectStructureConverter effectStructureConverter, boolean update, Iterable<Entity> entitiesToAnnotate) {
        Iterator<Entity> annotatedRecords = annotator.annotate(entitiesToAnnotate, update);
        if (annotator instanceof EffectCreatingAnnotator || annotator instanceof EffectBasedAnnotator) {
            annotatedRecords = effectStructureConverter.createVcfEntityStructure(annotatedRecords);
        }
        return annotatedRecords;
    }

    private static Iterable<Entity> addAnnotatorMetaDataToRepository(RepositoryAnnotator annotator, AttributeFactory attributeFactory, EffectStructureConverter effectStructureConverter, VcfRepository vcfRepo) {
        CmdLineAnnotatorUtils.addAnnotatorAttributesToInfoAttribute(annotator, vcfRepo);
        if (!(annotator instanceof EffectBasedAnnotator)) {
            AnnotatorUtils.addAnnotatorMetaDataToRepositories(vcfRepo.getEntityType(), attributeFactory, annotator);
            return vcfRepo;
        }
        Stream<Entity> entitiesToAnnotate = effectStructureConverter.createVariantEffectStructure(EFFECT, annotator.getOutputAttributes(), vcfRepo);
        return entitiesToAnnotate::iterator;
    }

    private static void writeAnnotationResultToVcfFile(List<String> attributesToInclude, BufferedWriter outputVCFWriter, List<Attribute> outputMetaData, Iterator<Entity> annotatedRecords) throws IOException {
        while (annotatedRecords.hasNext()) {
            Entity annotatedRecord = annotatedRecords.next();
            VcfWriterUtils.writeToVcf((Entity)annotatedRecord, (List)VcfUtils.getAtomicAttributesFromList(outputMetaData), attributesToInclude, (BufferedWriter)outputVCFWriter);
            outputVCFWriter.newLine();
        }
    }

    private static void addAnnotatorAttributesToInfoAttribute(RepositoryAnnotator annotator, VcfRepository vcfRepo) {
        EntityType entityType = vcfRepo.getEntityType();
        Attribute infoAttribute = entityType.getAttribute("INFO");
        for (Attribute attribute : annotator.getOutputAttributes()) {
            for (Attribute atomicAttribute : attribute.getChildren()) {
                atomicAttribute.setParent(infoAttribute);
                entityType.addAttribute(atomicAttribute, new EntityType.AttributeRole[0]);
            }
        }
    }

    private static List<Attribute> getOutputAttributeMetadatasForAnnotator(RepositoryAnnotator annotator, EntityTypeFactory entityTypeFactory, AttributeFactory attributeFactory, List<String> attributesToInclude, VcfRepository vcfRepo) {
        if (!attributesToInclude.isEmpty()) {
            CmdLineAnnotatorUtils.checkSelectedOutputAttributeNames(annotator, attributesToInclude, vcfRepo);
        }
        List<Object> outputMetaData = Lists.newArrayList();
        if (annotator instanceof EffectCreatingAnnotator || annotator instanceof EffectBasedAnnotator) {
            EntityType effectRefEntity = (EntityType)entityTypeFactory.create((Object)(annotator.getSimpleName() + "_EFFECTS"));
            for (Attribute outputAttribute : annotator.getOutputAttributes()) {
                effectRefEntity.addAttribute(outputAttribute, new EntityType.AttributeRole[0]);
            }
            Attribute effect = attributeFactory.create().setName(EFFECT);
            effect.setDataType(AttributeType.MREF).setRefEntity(effectRefEntity);
            outputMetaData.add(effect);
        } else {
            outputMetaData = annotator.getOutputAttributes();
        }
        return outputMetaData;
    }

    private static void checkSelectedOutputAttributeNames(RepositoryAnnotator annotator, List<String> attributesToInclude, VcfRepository vcfRepo) {
        List outputAttributeNames = VcfUtils.getAtomicAttributesFromList(annotator.getOutputAttributes()).stream().map(Attribute::getName).collect(Collectors.toList());
        List inputAttributeNames = VcfUtils.getAtomicAttributesFromList((Iterable)vcfRepo.getEntityType().getAtomicAttributes()).stream().map(Attribute::getName).collect(Collectors.toList());
        for (String attrName : attributesToInclude) {
            if (!outputAttributeNames.contains(attrName)) {
                throw new RuntimeException("Unknown output attribute '" + attrName + "'");
            }
            if (!inputAttributeNames.contains(attrName)) continue;
            throw new RuntimeException("The output attribute '" + attrName + "' is present in the inputfile, but is deselected in the current run, this is not supported");
        }
    }
}

