/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.annotation.core.utils;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.PeekingIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.StringUtils;
import org.molgenis.data.Entity;
import org.molgenis.data.meta.AttributeType;
import org.molgenis.data.meta.model.Attribute;
import org.molgenis.data.meta.model.AttributeFactory;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.data.meta.model.EntityTypeFactory;
import org.molgenis.data.support.DynamicEntity;
import org.molgenis.data.vcf.VcfRepository;
import org.molgenis.data.vcf.utils.VcfUtils;
import org.springframework.stereotype.Component;

@Component
public class EffectStructureConverter {
    private EntityTypeFactory entityTypeFactory;
    private AttributeFactory attributeFactory;

    public EffectStructureConverter(EntityTypeFactory entityTypeFactory, AttributeFactory attributeFactory) {
        this.entityTypeFactory = entityTypeFactory;
        this.attributeFactory = attributeFactory;
    }

    public Iterator<Entity> createVcfEntityStructure(final Iterator<Entity> annotatedRecords) {
        return new Iterator<Entity>(){
            final PeekingIterator<Entity> effects;
            EntityType vcfVariantEntityType;
            EntityType effectEntityType;
            {
                this.effects = Iterators.peekingIterator((Iterator)annotatedRecords);
            }

            private void createResultEntityType(Entity effect, EntityType variantEMD) {
                if (this.vcfVariantEntityType == null || this.effectEntityType == null) {
                    this.effectEntityType = effect.getEntityType();
                    this.vcfVariantEntityType = EntityType.newInstance((EntityType)variantEMD);
                    this.vcfVariantEntityType.addAttribute(EffectStructureConverter.this.attributeFactory.create().setName("EFFECT").setDataType(AttributeType.MREF).setRefEntity(this.effectEntityType), new EntityType.AttributeRole[0]);
                }
            }

            @Override
            public boolean hasNext() {
                return this.effects.hasNext();
            }

            @Override
            public Entity next() {
                Entity variant = null;
                ArrayList effectsForVariant = Lists.newArrayList();
                while (this.effects.hasNext()) {
                    String peekedId = ((Entity)this.effects.peek()).getEntity("VARIANT").getIdValue().toString();
                    if (variant == null || variant.getIdValue().toString().equals(peekedId)) {
                        Entity effect = (Entity)this.effects.next();
                        variant = effect.getEntity("VARIANT");
                        effectsForVariant.add(effect);
                        continue;
                    }
                    return this.createVcfEntityStructureForSingleEntity(variant, effectsForVariant);
                }
                return this.createVcfEntityStructureForSingleEntity(variant, effectsForVariant);
            }

            private Entity createVcfEntityStructureForSingleEntity(Entity variant, List<Entity> effectsForVariant) {
                this.createResultEntityType(effectsForVariant.get(0), variant.getEntityType());
                DynamicEntity newVariant = new DynamicEntity(this.vcfVariantEntityType);
                newVariant.set(variant);
                if (effectsForVariant.size() > 1) {
                    newVariant.set("EFFECT", effectsForVariant);
                } else {
                    Entity effectForVariant = effectsForVariant.get(0);
                    if (!this.isEmptyEffectEntity(effectForVariant)) {
                        newVariant.set("EFFECT", effectsForVariant);
                    }
                }
                return newVariant;
            }

            private boolean isEmptyEffectEntity(Entity effectEntity) {
                boolean isEmpty = true;
                for (Attribute effectAttribute : this.effectEntityType.getAtomicAttributes()) {
                    if (effectAttribute.getName().equals(this.effectEntityType.getIdAttribute().getName()) || effectAttribute.getName().equals("VARIANT") || effectEntity.get(effectAttribute.getName()) == null) continue;
                    isEmpty = false;
                    break;
                }
                return isEmpty;
            }
        };
    }

    public Stream<Entity> createVariantEffectStructure(String effectAttributeName, List<Attribute> annotatorAttributes, VcfRepository vcfRepository) {
        EntityType inputVcfEntityType = vcfRepository.getEntityType();
        EntityType variantEntityType = this.removeAttributeAndCreateEntityTypeCopy(vcfRepository.getEntityType().getAttribute("EFFECT"), vcfRepository.getEntityType());
        Attribute effectsAttribute = inputVcfEntityType.getAttribute(effectAttributeName);
        String description = this.getEffectDescription(effectsAttribute);
        String[] step1 = description.split(":");
        String effectEntityName = StringUtils.deleteWhitespace((String)step1[0]);
        String attributesString = step1[1].replaceAll("^\\s'|'$", "");
        ArrayList<Attribute> effectFieldAttributeList = this.parseEffectAttributeDescription(attributesString, annotatorAttributes);
        EntityType effectsEntityType = this.createEffectsEntityType(effectFieldAttributeList, effectEntityName, annotatorAttributes);
        return StreamSupport.stream(vcfRepository.spliterator(), false).flatMap(entity -> this.createVariantEffectStructureForSingleEntity(effectsAttribute, effectFieldAttributeList, effectsEntityType, (Entity)entity, variantEntityType));
    }

    private EntityType removeAttributeAndCreateEntityTypeCopy(Attribute attributeToParse, EntityType inputEntityType) {
        EntityType newMeta = EntityType.newInstance((EntityType)inputEntityType);
        newMeta.removeAttribute(attributeToParse);
        return newMeta;
    }

    private Stream<Entity> createVariantEffectStructureForSingleEntity(Attribute attributeToParse, ArrayList<Attribute> effectFieldAttributeList, EntityType effectsEntityType, Entity vcfInputEntity, EntityType variantEntityType) {
        ArrayList results = new ArrayList();
        DynamicEntity variantEntity = new DynamicEntity(variantEntityType);
        for (String attr : variantEntity.getAttributeNames()) {
            if (vcfInputEntity.getEntityType().getAttribute(attr) == null) continue;
            variantEntity.set(attr, vcfInputEntity.get(attr));
        }
        List result = EffectStructureConverter.createEffectsEntitiesForSingleVariant(effectsEntityType, effectFieldAttributeList, vcfInputEntity.getString(attributeToParse.getName()), (Entity)variantEntity).collect(Collectors.toList());
        results.addAll(result);
        return results.stream();
    }

    public String getEffectDescription(Attribute effectAttributeToParse) {
        String description = effectAttributeToParse.getDescription();
        if (description.indexOf(58) == -1) {
            throw new RuntimeException("Unable to create entitystructure, missing semicolon in description of [" + effectAttributeToParse.getName() + "]");
        }
        return description;
    }

    private EntityType createEffectsEntityType(ArrayList<Attribute> effectFieldAttributeList, String effectEntityName, List<Attribute> annotatorAttributes) {
        EntityType effectsEntityType = (EntityType)this.entityTypeFactory.create((Object)effectEntityName);
        effectsEntityType.addAttribute(this.attributeFactory.create().setName("identifier").setAuto(true).setVisible(false), new EntityType.AttributeRole[]{EntityType.AttributeRole.ROLE_ID});
        effectsEntityType.addAttributes(effectFieldAttributeList);
        this.addAnnotatorAttributes(annotatorAttributes, effectsEntityType);
        effectsEntityType.addAttribute(this.attributeFactory.create().setName("VARIANT").setDataType(AttributeType.XREF), new EntityType.AttributeRole[0]);
        return effectsEntityType;
    }

    private void addAnnotatorAttributes(List<Attribute> annotatorAttributes, EntityType effectsEntityType) {
        for (Attribute attr : annotatorAttributes) {
            if (effectsEntityType.getAttribute(attr.getName()) != null) continue;
            effectsEntityType.addAttribute(attr, new EntityType.AttributeRole[0]);
        }
    }

    private ArrayList<Attribute> parseEffectAttributeDescription(String attributesString, List<Attribute> annotatorAttributes) {
        String[] attributeStrings = attributesString.replaceAll("^\\s'|'$", "").split("\\|");
        ArrayList<Attribute> attributeList = new ArrayList<Attribute>();
        Map annotatorAttributeMap = VcfUtils.getAttributesMapFromList(annotatorAttributes);
        for (String attribute : attributeStrings) {
            AttributeType type = annotatorAttributeMap.containsKey(attribute) ? ((Attribute)annotatorAttributeMap.get(attribute)).getDataType() : AttributeType.STRING;
            Attribute attr = this.attributeFactory.create().setName(StringUtils.deleteWhitespace((String)attribute)).setDataType(type).setLabel(attribute);
            attributeList.add(attr);
        }
        return attributeList;
    }

    private static Stream<Entity> createEffectsEntitiesForSingleVariant(EntityType effectsEntityType, List<Attribute> effectFieldAttributeList, String descriptionFieldsString, Entity variantEntity) {
        String[] descriptionFieldValues;
        ArrayList<DynamicEntity> listOfEffectsEntities = new ArrayList<DynamicEntity>();
        if (descriptionFieldsString == null) {
            return listOfEffectsEntities.stream();
        }
        for (String descriptionFieldValue : descriptionFieldValues = descriptionFieldsString.split(",")) {
            String[] descriptionFieldPartValues = descriptionFieldValue.split("\\|", -1);
            DynamicEntity singleEffectsEntity = new DynamicEntity(effectsEntityType);
            int i = 0;
            for (Attribute attribute : effectFieldAttributeList) {
                if (i > descriptionFieldPartValues.length) {
                    throw new RuntimeException("Description of the attribute contains more values (pipe separated values) than the actual value");
                }
                singleEffectsEntity.set(attribute.getName(), (Object)descriptionFieldPartValues[i]);
                ++i;
            }
            singleEffectsEntity.set("VARIANT", (Object)variantEntity);
            listOfEffectsEntities.add(singleEffectsEntity);
        }
        return listOfEffectsEntities.stream();
    }
}

