/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.annotation.core.utils;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.molgenis.data.annotation.core.utils.JarRunner;
import org.springframework.stereotype.Component;

@Component
public class JarRunnerImpl
implements JarRunner {
    @Override
    public File runJar(String outputFile, List<String> params, File inputVcf) throws IOException, InterruptedException {
        File outputVcf = File.createTempFile(outputFile, ".vcf");
        ArrayList<String> command = new ArrayList<String>();
        command.add("java");
        command.add("-jar");
        command.addAll(params);
        command.add(inputVcf.getAbsolutePath());
        ProcessBuilder pb = new ProcessBuilder(command);
        pb.redirectOutput(outputVcf);
        pb.redirectError(ProcessBuilder.Redirect.INHERIT);
        Process p = pb.start();
        p.waitFor();
        return outputVcf;
    }
}

