/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.annotation.core.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import org.json.JSONArray;
import org.json.JSONObject;

public class JsonReader {
    private static String readAll(Reader rd) throws IOException {
        int cp;
        StringBuilder sb = new StringBuilder();
        while ((cp = rd.read()) != -1) {
            sb.append((char)cp);
        }
        return sb.toString();
    }

    public static JSONObject readJsonFromUrl(String url) throws IOException {
        try (InputStream is = new URL(url).openStream();){
            JSONObject json;
            BufferedReader rd = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
            String jsonText = JsonReader.readAll(rd);
            JSONObject jSONObject = json = new JSONObject(jsonText);
            return jSONObject;
        }
    }

    public static void main(String[] args) throws IOException {
        String geneNetworkUrl = "http://molgenis58.target.rug.nl/api/v1/prioritization/HP:0000707,HP:0001300,HP:0002015?verbose&genes=BRCA1,BRCA2";
        JSONObject geneNetworkJsonCallback = JsonReader.readJsonFromUrl(geneNetworkUrl);
        JSONArray jsonResults = geneNetworkJsonCallback.getJSONArray("results");
        for (int i = 0; i < jsonResults.length(); ++i) {
            System.out.println(jsonResults.getJSONObject(i).toString());
        }
    }
}

