/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.annotation.web;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.molgenis.data.UnknownEntityException;
import org.molgenis.data.annotation.core.RepositoryAnnotator;
import org.molgenis.data.annotation.web.AnnotationService;
import org.molgenis.data.meta.model.EntityType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class AnnotationServiceImpl
implements AnnotationService {
    private List<RepositoryAnnotator> annotators = null;
    @Autowired
    private ApplicationContext applicationContext;

    @Override
    public RepositoryAnnotator getAnnotatorByName(String annotatorName) {
        this.getAllAnnotators();
        for (RepositoryAnnotator annotator : this.annotators) {
            if (!annotator.getSimpleName().equalsIgnoreCase(annotatorName)) continue;
            return annotator;
        }
        throw new UnknownEntityException("Unknown annotator [" + annotatorName + "]");
    }

    @Override
    public List<RepositoryAnnotator> getAnnotatorsByMetaData(EntityType metaData) {
        this.getAllAnnotators();
        ArrayList result = Lists.newArrayList();
        for (RepositoryAnnotator annotator : this.annotators) {
            if (!annotator.canAnnotate(metaData).equals("true")) continue;
            result.add(annotator);
        }
        return result;
    }

    @Override
    public List<RepositoryAnnotator> getAllAnnotators() {
        if (this.annotators == null) {
            this.annotators = new ArrayList<RepositoryAnnotator>();
            Map configuredAnnotators = this.applicationContext.getBeansOfType(RepositoryAnnotator.class);
            this.annotators.addAll(configuredAnnotators.values());
        }
        return this.annotators;
    }
}

