/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.annotation.web;

import java.util.Iterator;
import java.util.Spliterators;
import java.util.stream.StreamSupport;
import org.molgenis.data.DataService;
import org.molgenis.data.DatabaseAction;
import org.molgenis.data.Entity;
import org.molgenis.data.Repository;
import org.molgenis.data.RepositoryCapability;
import org.molgenis.data.annotation.core.EffectCreatingAnnotator;
import org.molgenis.data.annotation.core.RepositoryAnnotator;
import org.molgenis.data.annotation.core.exception.AnnotationException;
import org.molgenis.data.annotation.core.exception.UiAnnotationException;
import org.molgenis.data.annotation.core.utils.AnnotatorUtils;
import org.molgenis.data.meta.model.AttributeFactory;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.data.security.permission.PermissionSystemService;
import org.molgenis.security.core.runas.RunAsSystemAspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class CrudRepositoryAnnotator {
    private static final Logger LOG = LoggerFactory.getLogger(CrudRepositoryAnnotator.class);
    private final DataService dataService;
    private final PermissionSystemService permissionSystemService;
    private EntityType targetMetaData;
    private AttributeFactory attributeFactory;

    public CrudRepositoryAnnotator(DataService dataService, PermissionSystemService permissionSystemService, AttributeFactory attributeFactory) {
        this.dataService = dataService;
        this.permissionSystemService = permissionSystemService;
        this.attributeFactory = attributeFactory;
    }

    public void annotate(RepositoryAnnotator annotator, Repository<Entity> repository) {
        this.annotate(annotator, repository, DatabaseAction.UPDATE);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void annotate(RepositoryAnnotator annotator, Repository<Entity> repository, DatabaseAction action) {
        if (!repository.getCapabilities().contains(RepositoryCapability.WRITABLE)) {
            throw new UnsupportedOperationException("Currently only writable repositories can be annotated");
        }
        try {
            EntityType entityType = this.dataService.getMeta().getEntityType(repository.getName());
            if (annotator instanceof EffectCreatingAnnotator) {
                this.targetMetaData = ((EffectCreatingAnnotator)((Object)annotator)).getTargetEntityType(entityType);
                if (this.dataService.hasRepository(this.targetMetaData.getId())) throw new UnsupportedOperationException("This entity has already been annotated with " + annotator.getSimpleName());
                Repository externalRepository = this.dataService.getMeta().createRepository(this.targetMetaData);
                this.permissionSystemService.giveUserWriteMetaPermissions(this.targetMetaData);
                RunAsSystemAspect.runAsSystem(() -> this.dataService.getMeta().updateEntityType(externalRepository.getEntityType()));
                this.iterateOverEntitiesAndAnnotate(repository, annotator, DatabaseAction.ADD);
                return;
            } else {
                RunAsSystemAspect.runAsSystem(() -> this.dataService.getMeta().updateEntityType(AnnotatorUtils.addAnnotatorMetaDataToRepositories(entityType, this.attributeFactory, annotator)));
                this.iterateOverEntitiesAndAnnotate((Repository<Entity>)this.dataService.getRepository(repository.getName()), annotator, action);
            }
            return;
        }
        catch (AnnotationException ae) {
            this.deleteResultEntity(annotator, this.targetMetaData);
            throw new UiAnnotationException(ae);
        }
        catch (Exception e) {
            this.deleteResultEntity(annotator, this.targetMetaData);
            throw new RuntimeException(e);
        }
    }

    private void deleteResultEntity(RepositoryAnnotator annotator, EntityType targetMetaData) {
        try {
            if (annotator instanceof EffectCreatingAnnotator && targetMetaData != null) {
                RunAsSystemAspect.runAsSystem(() -> {
                    this.dataService.deleteAll(targetMetaData.getId());
                    this.dataService.getMeta().deleteEntityType(targetMetaData.getId());
                });
            }
        }
        catch (Exception ex) {
            LOG.error("Failed to remove result entity: %s", (Object)targetMetaData.getId());
        }
    }

    private void iterateOverEntitiesAndAnnotate(Repository<Entity> repository, RepositoryAnnotator annotator, DatabaseAction action) {
        Iterator<Entity> it = annotator.annotate((Iterable<Entity>)repository);
        String entityTypeId = annotator instanceof EffectCreatingAnnotator ? ((EffectCreatingAnnotator)((Object)annotator)).getTargetEntityType(repository.getEntityType()).getId() : repository.getName();
        switch (action) {
            case UPDATE: {
                this.dataService.update(entityTypeId, StreamSupport.stream(Spliterators.spliteratorUnknownSize(it, 16), false));
                break;
            }
            case ADD: {
                this.dataService.add(entityTypeId, StreamSupport.stream(Spliterators.spliteratorUnknownSize(it, 16), false));
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }
}

