/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.activiti.action;

import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.mule.api.MuleMessage;
import org.mule.api.MuleRuntimeException;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.module.activiti.ActivitiConnector;
import org.mule.module.activiti.action.OutboundActivitiAction;
import org.mule.module.activiti.i18n.ActivitiMessages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOutboundActivitiAction<V extends HttpMethod>
implements OutboundActivitiAction<V> {
    private String name;

    protected abstract URI resolveURI(OutboundEndpoint var1) throws URIException, NullPointerException;

    protected abstract void prepareMethod(V var1, MuleMessage var2) throws Exception;

    @Override
    public String executeUsing(ActivitiConnector connector, HttpClient client, MuleMessage message, OutboundEndpoint endpoint) {
        HttpMethod method = null;
        try {
            method = (HttpMethod)this.getMethod();
            connector.prepareMethod(method, client);
            URI methodURI = new URI(new URI(connector.getActivitiServerURL(), false), this.resolveURI(endpoint));
            method.setURI(methodURI);
            this.prepareMethod(method, message);
            client.executeMethod(method);
            String string = method.getResponseBodyAsString();
            return string;
        }
        catch (Exception e) {
            throw new MuleRuntimeException(ActivitiMessages.failToExecuteOutboundAction(this), (Throwable)e);
        }
        finally {
            method.releaseConnection();
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

