/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.spring;

import java.sql.SQLException;
import javax.sql.DataSource;
import org.mybatis.spring.MyBatisSystemException;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.jdbc.support.SQLErrorCodeSQLExceptionTranslator;
import org.springframework.jdbc.support.SQLExceptionTranslator;

public class MyBatisExceptionTranslator
implements PersistenceExceptionTranslator {
    private final DataSource dataSource;
    private SQLExceptionTranslator exceptionTranslator;

    public MyBatisExceptionTranslator(DataSource dataSource, boolean exceptionTranslatorLazyInit) {
        this.dataSource = dataSource;
        if (!exceptionTranslatorLazyInit) {
            this.initExceptionTranslator();
        }
    }

    public DataAccessException translateExceptionIfPossible(RuntimeException e) {
        if (e.getCause() instanceof SQLException) {
            this.initExceptionTranslator();
            return this.exceptionTranslator.translate(e.getMessage() + "\n", null, (SQLException)e.getCause());
        }
        return new MyBatisSystemException(e);
    }

    private synchronized void initExceptionTranslator() {
        if (this.exceptionTranslator == null) {
            this.exceptionTranslator = new SQLErrorCodeSQLExceptionTranslator(this.dataSource);
        }
    }
}

