/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.util;

import java.util.Collections;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class FingerPrintKeyer {
    static final Pattern punctctrl = Pattern.compile("\\p{Punct}|[\\x00-\\x08\\x0A-\\x1F\\x7F]");

    public String key(String s, Object ... o) {
        if (s == null || o != null && o.length > 0) {
            throw new IllegalArgumentException("Fingerprint keyer accepts a single string parameter");
        }
        s = s.trim();
        s = s.toLowerCase();
        s = punctctrl.matcher(s).replaceAll("");
        String[] frags = StringUtils.split((String)s);
        TreeSet set = new TreeSet();
        Collections.addAll(set, frags);
        StringBuilder b = new StringBuilder();
        Iterator i = set.iterator();
        while (i.hasNext()) {
            b.append((String)i.next());
            if (!i.hasNext()) continue;
            b.append(' ');
        }
        return this.asciify(b.toString());
    }

    protected String asciify(String s) {
        char[] c = s.toCharArray();
        StringBuilder b = new StringBuilder();
        for (char element : c) {
            b.append(this.translate(element));
        }
        return b.toString();
    }

    private char translate(char c) {
        switch (c) {
            case '\u00c0': 
            case '\u00c1': 
            case '\u00c2': 
            case '\u00c3': 
            case '\u00c4': 
            case '\u00c5': 
            case '\u00e0': 
            case '\u00e1': 
            case '\u00e2': 
            case '\u00e3': 
            case '\u00e4': 
            case '\u00e5': 
            case '\u0100': 
            case '\u0101': 
            case '\u0102': 
            case '\u0103': 
            case '\u0104': 
            case '\u0105': {
                return 'a';
            }
            case '\u00c7': 
            case '\u00e7': 
            case '\u0106': 
            case '\u0107': 
            case '\u0108': 
            case '\u0109': 
            case '\u010a': 
            case '\u010b': 
            case '\u010c': 
            case '\u010d': {
                return 'c';
            }
            case '\u00d0': 
            case '\u00f0': 
            case '\u010e': 
            case '\u010f': 
            case '\u0110': 
            case '\u0111': {
                return 'd';
            }
            case '\u00c8': 
            case '\u00c9': 
            case '\u00ca': 
            case '\u00cb': 
            case '\u00e8': 
            case '\u00e9': 
            case '\u00ea': 
            case '\u00eb': 
            case '\u0112': 
            case '\u0113': 
            case '\u0114': 
            case '\u0115': 
            case '\u0116': 
            case '\u0117': 
            case '\u0118': 
            case '\u0119': 
            case '\u011a': 
            case '\u011b': {
                return 'e';
            }
            case '\u011c': 
            case '\u011d': 
            case '\u011e': 
            case '\u011f': 
            case '\u0120': 
            case '\u0121': 
            case '\u0122': 
            case '\u0123': {
                return 'g';
            }
            case '\u0124': 
            case '\u0125': 
            case '\u0126': 
            case '\u0127': {
                return 'h';
            }
            case '\u00cc': 
            case '\u00cd': 
            case '\u00ce': 
            case '\u00cf': 
            case '\u00ec': 
            case '\u00ed': 
            case '\u00ee': 
            case '\u00ef': 
            case '\u0128': 
            case '\u0129': 
            case '\u012a': 
            case '\u012b': 
            case '\u012c': 
            case '\u012d': 
            case '\u012e': 
            case '\u012f': 
            case '\u0130': 
            case '\u0131': {
                return 'i';
            }
            case '\u0134': 
            case '\u0135': {
                return 'j';
            }
            case '\u0136': 
            case '\u0137': 
            case '\u0138': {
                return 'k';
            }
            case '\u0139': 
            case '\u013a': 
            case '\u013b': 
            case '\u013c': 
            case '\u013d': 
            case '\u013e': 
            case '\u013f': 
            case '\u0140': 
            case '\u0141': 
            case '\u0142': {
                return 'l';
            }
            case '\u00d1': 
            case '\u00f1': 
            case '\u0143': 
            case '\u0144': 
            case '\u0145': 
            case '\u0146': 
            case '\u0147': 
            case '\u0148': 
            case '\u0149': 
            case '\u014a': 
            case '\u014b': {
                return 'n';
            }
            case '\u00d2': 
            case '\u00d3': 
            case '\u00d4': 
            case '\u00d5': 
            case '\u00d6': 
            case '\u00d8': 
            case '\u00f2': 
            case '\u00f3': 
            case '\u00f4': 
            case '\u00f5': 
            case '\u00f6': 
            case '\u00f8': 
            case '\u014c': 
            case '\u014d': 
            case '\u014e': 
            case '\u014f': 
            case '\u0150': 
            case '\u0151': {
                return 'o';
            }
            case '\u0154': 
            case '\u0155': 
            case '\u0156': 
            case '\u0157': 
            case '\u0158': 
            case '\u0159': {
                return 'r';
            }
            case '\u015a': 
            case '\u015b': 
            case '\u015c': 
            case '\u015d': 
            case '\u015e': 
            case '\u015f': 
            case '\u0160': 
            case '\u0161': 
            case '\u017f': {
                return 's';
            }
            case '\u0162': 
            case '\u0163': 
            case '\u0164': 
            case '\u0165': 
            case '\u0166': 
            case '\u0167': {
                return 't';
            }
            case '\u00d9': 
            case '\u00da': 
            case '\u00db': 
            case '\u00dc': 
            case '\u00f9': 
            case '\u00fa': 
            case '\u00fb': 
            case '\u00fc': 
            case '\u0168': 
            case '\u0169': 
            case '\u016a': 
            case '\u016b': 
            case '\u016c': 
            case '\u016d': 
            case '\u016e': 
            case '\u016f': 
            case '\u0170': 
            case '\u0171': 
            case '\u0172': 
            case '\u0173': {
                return 'u';
            }
            case '\u0174': 
            case '\u0175': {
                return 'w';
            }
            case '\u00dd': 
            case '\u00fd': 
            case '\u00ff': 
            case '\u0176': 
            case '\u0177': 
            case '\u0178': {
                return 'y';
            }
            case '\u0179': 
            case '\u017a': 
            case '\u017b': 
            case '\u017c': 
            case '\u017d': 
            case '\u017e': {
                return 'z';
            }
        }
        return c;
    }
}

