/*
 * Decompiled with CFR 0.152.
 */
package org.noear.liquor;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.JarEntry;
import java.util.stream.Collectors;
import javax.tools.JavaFileObject;
import org.noear.liquor.ClassUriWrapper;
import org.noear.liquor.CustomJavaFileObject;

public class PackageInternalsFinder {
    private final ClassLoader classLoader;
    private static final String CLASS_FILE_EXTENSION = ".class";
    private static final Map<String, JarFileIndex> INDEXS = new ConcurrentHashMap<String, JarFileIndex>();

    public PackageInternalsFinder(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public List<JavaFileObject> find(String packageName) throws IOException {
        String javaPackageName = packageName.replaceAll("\\.", "/");
        ArrayList<JavaFileObject> result = new ArrayList<JavaFileObject>();
        Enumeration<URL> urlEnumeration = this.classLoader.getResources(javaPackageName);
        while (urlEnumeration.hasMoreElements()) {
            URL packageFolderURL = urlEnumeration.nextElement();
            result.addAll(this.listUnder(packageName, packageFolderURL));
        }
        return result;
    }

    private Collection<JavaFileObject> listUnder(String packageName, URL packageFolderURL) {
        File directory = new File(this.decode(packageFolderURL.getFile()));
        if (directory.isDirectory()) {
            return this.processDir(packageName, directory);
        }
        return this.processJar(packageName, packageFolderURL);
    }

    private List<JavaFileObject> processJar(String packageName, URL packageFolderURL) {
        try {
            List<JavaFileObject> result;
            String jarUri = packageFolderURL.toExternalForm().substring(0, packageFolderURL.toExternalForm().lastIndexOf("!/"));
            JarFileIndex jarFileIndex = INDEXS.get(jarUri);
            if (jarFileIndex == null) {
                jarFileIndex = new JarFileIndex(jarUri, URI.create(jarUri + "!/"));
                INDEXS.put(jarUri, jarFileIndex);
            }
            if ((result = jarFileIndex.search(packageName)) != null) {
                return result;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.fuse(packageFolderURL);
    }

    private List<JavaFileObject> fuse(URL packageFolderURL) {
        ArrayList<JavaFileObject> result = new ArrayList<JavaFileObject>();
        try {
            String jarUri = packageFolderURL.toExternalForm().substring(0, packageFolderURL.toExternalForm().lastIndexOf("!/"));
            JarURLConnection jarConn = (JarURLConnection)packageFolderURL.openConnection();
            String rootEntryName = jarConn.getEntryName();
            int rootEnd = rootEntryName.length() + 1;
            Enumeration<JarEntry> entryEnum = jarConn.getJarFile().entries();
            while (entryEnum.hasMoreElements()) {
                JarEntry jarEntry = entryEnum.nextElement();
                String name = jarEntry.getName();
                if (!name.startsWith(rootEntryName) || name.indexOf(47, rootEnd) != -1 || !name.endsWith(CLASS_FILE_EXTENSION)) continue;
                URI uri = URI.create(jarUri + "!/" + name);
                String binaryName = name.replaceAll("/", ".");
                binaryName = binaryName.replaceAll(".class$", "");
                result.add(new CustomJavaFileObject(binaryName, uri));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Wasn't able to open " + packageFolderURL + " as a jar file", e);
        }
        return result;
    }

    private List<JavaFileObject> processDir(String packageName, File directory) {
        File[] files = directory.listFiles(item -> item.isFile() && PackageInternalsFinder.getKind(item.getName()) == JavaFileObject.Kind.CLASS);
        if (files != null) {
            return Arrays.stream(files).map(item -> {
                String className = packageName + "." + item.getName().replaceAll(".class$", "");
                return new CustomJavaFileObject(className, item.toURI());
            }).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private String decode(String filePath) {
        try {
            return URLDecoder.decode(filePath, "utf-8");
        }
        catch (Exception exception) {
            return filePath;
        }
    }

    public static JavaFileObject.Kind getKind(String name) {
        if (name.endsWith(JavaFileObject.Kind.CLASS.extension)) {
            return JavaFileObject.Kind.CLASS;
        }
        if (name.endsWith(JavaFileObject.Kind.SOURCE.extension)) {
            return JavaFileObject.Kind.SOURCE;
        }
        if (name.endsWith(JavaFileObject.Kind.HTML.extension)) {
            return JavaFileObject.Kind.HTML;
        }
        return JavaFileObject.Kind.OTHER;
    }

    public static class JarFileIndex {
        private String jarUri;
        private URI uri;
        private Map<String, List<ClassUriWrapper>> packages = new HashMap<String, List<ClassUriWrapper>>();

        public JarFileIndex(String jarUri, URI uri) throws IOException {
            this.jarUri = jarUri;
            this.uri = uri;
            this.loadIndex();
        }

        private void loadIndex() throws IOException {
            JarURLConnection jarConn = (JarURLConnection)this.uri.toURL().openConnection();
            String rootEntryName = jarConn.getEntryName() == null ? "" : jarConn.getEntryName();
            Enumeration<JarEntry> entryEnum = jarConn.getJarFile().entries();
            while (entryEnum.hasMoreElements()) {
                JarEntry jarEntry = entryEnum.nextElement();
                String entryName = jarEntry.getName();
                if (!entryName.startsWith(rootEntryName) || !entryName.endsWith(PackageInternalsFinder.CLASS_FILE_EXTENSION)) continue;
                String className = entryName.substring(0, entryName.length() - PackageInternalsFinder.CLASS_FILE_EXTENSION.length()).replace(rootEntryName, "").replace("/", ".");
                if (className.startsWith(".")) {
                    className = className.substring(1);
                }
                if (className.equals("package-info") || className.equals("module-info") || className.lastIndexOf(".") == -1) continue;
                String packageName = className.substring(0, className.lastIndexOf("."));
                List<ClassUriWrapper> classes = this.packages.get(packageName);
                if (classes == null) {
                    classes = new ArrayList<ClassUriWrapper>();
                    this.packages.put(packageName, classes);
                }
                classes.add(new ClassUriWrapper(className, URI.create(this.jarUri + "!/" + entryName)));
            }
        }

        public List<JavaFileObject> search(String packageName) {
            if (this.packages.isEmpty()) {
                return null;
            }
            if (this.packages.containsKey(packageName)) {
                return this.packages.get(packageName).stream().map(item -> new CustomJavaFileObject(item.getClassName(), item.getUri())).collect(Collectors.toList());
            }
            return Collections.emptyList();
        }
    }
}

